"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDownloadExportedRules = useDownloadExportedRules;
var _react = require("react");
var _request_schema = require("../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _download_blob = require("../../../../common/utils/download_blob");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _helpers = require("../../../rule_management_ui/components/rules_table/helpers");
var _use_show_bulk_error_toast = require("./use_show_bulk_error_toast");
var _use_show_bulk_success_toast = require("./use_show_bulk_success_toast");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_EXPORT_FILENAME = `${i18n.EXPORT_FILENAME}.ndjson`;

/**
 * downloads exported rules, received from export action
 */
function useDownloadExportedRules() {
  const showBulkSuccessToast = (0, _use_show_bulk_success_toast.useShowBulkSuccessToast)();
  const showBulkErrorToast = (0, _use_show_bulk_error_toast.useShowBulkErrorToast)();
  return (0, _react.useCallback)(async response => {
    try {
      (0, _download_blob.downloadBlob)(response, DEFAULT_EXPORT_FILENAME);
      showBulkSuccessToast({
        actionType: _request_schema.BulkActionType.export,
        summary: await (0, _helpers.getExportedRulesCounts)(response)
      });
    } catch (error) {
      showBulkErrorToast({
        actionType: _request_schema.BulkActionType.export,
        error
      });
    }
  }, [showBulkSuccessToast, showBulkErrorToast]);
}