"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleSnoozeSettings = useRuleSnoozeSettings;
var _use_fetch_rules_snooze_settings = require("../../api/hooks/use_fetch_rules_snooze_settings");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRuleSnoozeSettings(id) {
  var _useRulesTableContext, _rulesTableSnoozeSett;
  const {
    state: {
      rulesSnoozeSettings: rulesTableSnoozeSettings
    }
  } = (_useRulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)()) !== null && _useRulesTableContext !== void 0 ? _useRulesTableContext : {
    state: {}
  };
  const {
    data: rulesSnoozeSettings,
    isFetching: isSingleSnoozeSettingsFetching,
    isError: isSingleSnoozeSettingsError
  } = (0, _use_fetch_rules_snooze_settings.useFetchRulesSnoozeSettings)([id], {
    enabled: !(rulesTableSnoozeSettings !== null && rulesTableSnoozeSettings !== void 0 && rulesTableSnoozeSettings.data[id]) && !(rulesTableSnoozeSettings !== null && rulesTableSnoozeSettings !== void 0 && rulesTableSnoozeSettings.isFetching)
  });
  const snoozeSettings = (_rulesTableSnoozeSett = rulesTableSnoozeSettings === null || rulesTableSnoozeSettings === void 0 ? void 0 : rulesTableSnoozeSettings.data[id]) !== null && _rulesTableSnoozeSett !== void 0 ? _rulesTableSnoozeSett : rulesSnoozeSettings === null || rulesSnoozeSettings === void 0 ? void 0 : rulesSnoozeSettings[id];
  const isFetching = (rulesTableSnoozeSettings === null || rulesTableSnoozeSettings === void 0 ? void 0 : rulesTableSnoozeSettings.isFetching) || isSingleSnoozeSettingsFetching;
  const isError = (rulesTableSnoozeSettings === null || rulesTableSnoozeSettings === void 0 ? void 0 : rulesTableSnoozeSettings.isError) || isSingleSnoozeSettingsError;
  return {
    snoozeSettings,
    error: isError || !snoozeSettings && !isFetching ? i18n.UNABLE_TO_FETCH_RULES_SNOOZE_SETTINGS : undefined
  };
}