"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstallFleetPackageMutation = exports.INSTALL_FLEET_PACKAGE_MUTATION_KEY = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../../common/detection_engine/constants");
var _api = require("../api");
var _use_fetch_prebuilt_rules_status_query = require("./use_fetch_prebuilt_rules_status_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_FLEET_PACKAGE_MUTATION_KEY = ['POST', _common.EPM_API_ROUTES.INSTALL_FROM_REGISTRY_PATTERN];
exports.INSTALL_FLEET_PACKAGE_MUTATION_KEY = INSTALL_FLEET_PACKAGE_MUTATION_KEY;
const useInstallFleetPackageMutation = options => {
  const invalidatePrePackagedRulesStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  return (0, _reactQuery.useMutation)(props => (0, _api.installFleetPackage)(props), {
    ...options,
    mutationKey: INSTALL_FLEET_PACKAGE_MUTATION_KEY,
    onSettled: (...args) => {
      const {
        packageName
      } = args[2];
      if (packageName === _constants.PREBUILT_RULES_PACKAGE_NAME) {
        // Invalidate the pre-packaged rules status query as there might be new rules to install
        invalidatePrePackagedRulesStatus();
      }
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useInstallFleetPackageMutation = useInstallFleetPackageMutation;