"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchRuleManagementFiltersQuery = exports.useFetchRuleManagementFiltersQuery = exports.RULE_MANAGEMENT_FILTERS_QUERY_KEY = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _urls = require("../../../../../common/detection_engine/rule_management/api/urls");
var _api = require("../api");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_MANAGEMENT_FILTERS_QUERY_KEY = ['GET', _urls.RULE_MANAGEMENT_FILTERS_URL];
exports.RULE_MANAGEMENT_FILTERS_QUERY_KEY = RULE_MANAGEMENT_FILTERS_QUERY_KEY;
const useFetchRuleManagementFiltersQuery = options => {
  return (0, _reactQuery.useQuery)(RULE_MANAGEMENT_FILTERS_QUERY_KEY, async ({
    signal
  }) => {
    const response = await (0, _api.fetchRuleManagementFilters)({
      signal
    });
    return response;
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...options
  });
};

/**
 * We should use this hook to invalidate the rule management filters cache. For
 * example, rule mutations that affect rule set size, like creation or deletion,
 * should lead to cache invalidation.
 *
 * @returns A rules cache invalidation callback
 */
exports.useFetchRuleManagementFiltersQuery = useFetchRuleManagementFiltersQuery;
const useInvalidateFetchRuleManagementFiltersQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(RULE_MANAGEMENT_FILTERS_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchRuleManagementFiltersQuery = useInvalidateFetchRuleManagementFiltersQuery;