"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateRuleMutation = exports.CREATE_RULE_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../../common/constants");
var _transforms = require("../../../../detections/containers/detection_engine/rules/transforms");
var _api = require("../api");
var _use_fetch_rule_management_filters_query = require("./use_fetch_rule_management_filters_query");
var _use_find_rules_query = require("./use_find_rules_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_RULE_MUTATION_KEY = ['POST', _constants.DETECTION_ENGINE_RULES_URL];
exports.CREATE_RULE_MUTATION_KEY = CREATE_RULE_MUTATION_KEY;
const useCreateRuleMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  return (0, _reactQuery.useMutation)(rule => (0, _api.createRule)({
    rule: (0, _transforms.transformOutput)(rule)
  }), {
    ...options,
    mutationKey: CREATE_RULE_MUTATION_KEY,
    onSettled: (...args) => {
      invalidateFindRulesQuery();
      invalidateFetchRuleManagementFilters();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useCreateRuleMutation = useCreateRuleMutation;