"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreatePrebuiltRulesMutation = exports.CREATE_PREBUILT_RULES_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _urls = require("../../../../../common/detection_engine/prebuilt_rules/api/urls");
var _api = require("../api");
var _use_fetch_prebuilt_rules_status_query = require("./use_fetch_prebuilt_rules_status_query");
var _use_find_rules_query = require("./use_find_rules_query");
var _use_fetch_rule_management_filters_query = require("./use_fetch_rule_management_filters_query");
var _use_fetch_rules_snooze_settings = require("./use_fetch_rules_snooze_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_PREBUILT_RULES_MUTATION_KEY = ['PUT', _urls.PREBUILT_RULES_URL];
exports.CREATE_PREBUILT_RULES_MUTATION_KEY = CREATE_PREBUILT_RULES_MUTATION_KEY;
const useCreatePrebuiltRulesMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRulesSnoozeSettings = (0, _use_fetch_rules_snooze_settings.useInvalidateFetchRulesSnoozeSettingsQuery)();
  const invalidatePrePackagedRulesStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  return (0, _reactQuery.useMutation)(() => (0, _api.createPrepackagedRules)(), {
    ...options,
    mutationKey: CREATE_PREBUILT_RULES_MUTATION_KEY,
    onSettled: (...args) => {
      // Always invalidate all rules and the prepackaged rules status cache as
      // the number of rules might change after the installation
      invalidatePrePackagedRulesStatus();
      invalidateFindRulesQuery();
      invalidateFetchRulesSnoozeSettings();
      invalidateFetchRuleManagementFilters();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useCreatePrebuiltRulesMutation = useCreatePrebuiltRulesMutation;