"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_EXCEPTION_CONDITIONS = exports.OPERATING_SYSTEM_PLACEHOLDER = exports.EXCEPTION_BUILDER_INFO = exports.EDIT_EXCEPTION_SEQUENCE_WARNING = exports.ADD_EXCEPTION_SEQUENCE_WARNING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Conditions component
const RULE_EXCEPTION_CONDITIONS = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.itemConditions.conditionsTitle', {
  defaultMessage: 'Conditions'
});
exports.RULE_EXCEPTION_CONDITIONS = RULE_EXCEPTION_CONDITIONS;
const EXCEPTION_BUILDER_INFO = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.itemConditions.infoLabel', {
  defaultMessage: "Alerts are generated when the rule's conditions are met, except when:"
});
exports.EXCEPTION_BUILDER_INFO = EXCEPTION_BUILDER_INFO;
const ADD_EXCEPTION_SEQUENCE_WARNING = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.itemConditions.sequenceWarningAdd', {
  defaultMessage: "This rule's query contains an EQL sequence statement. The exception created will apply to all events in the sequence."
});
exports.ADD_EXCEPTION_SEQUENCE_WARNING = ADD_EXCEPTION_SEQUENCE_WARNING;
const EDIT_EXCEPTION_SEQUENCE_WARNING = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.itemConditions.sequenceWarningEdit', {
  defaultMessage: "This rule's query contains an EQL sequence statement. The exception modified will apply to all events in the sequence."
});
exports.EDIT_EXCEPTION_SEQUENCE_WARNING = EDIT_EXCEPTION_SEQUENCE_WARNING;
const OPERATING_SYSTEM_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.flyoutComponents.itemConditions.operatingSystemPlaceHolder', {
  defaultMessage: 'Select an operating system'
});
exports.OPERATING_SYSTEM_PLACEHOLDER = OPERATING_SYSTEM_PLACEHOLDER;