"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToListsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_add_to_lists_table = require("./use_add_to_lists_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsAddToListsComponent = ({
  showAllSharedLists,
  sharedExceptionLists,
  onListSelectionChange
}) => {
  const {
    error,
    isLoading,
    pagination,
    lists,
    listTableColumnsWithLinkSwitch,
    onTableChange,
    addToSelectedListDescription
  } = (0, _use_add_to_lists_table.useAddToSharedListTable)({
    showAllSharedLists,
    sharedExceptionLists,
    onListSelectionChange
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, addToSelectedListDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    sorting: true,
    tableLayout: "auto",
    tableCaption: "Table of exception lists",
    "data-test-subj": "addExceptionToSharedListsTable",
    error: error,
    items: lists,
    loading: isLoading,
    message: isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
      lines: 4,
      "data-test-subj": "exceptionItemViewerEmptyPrompts-loading"
    }) : undefined,
    columns: listTableColumnsWithLinkSwitch,
    pagination: pagination,
    onTableChange: onTableChange
  })));
};
const ExceptionsAddToListsTable = /*#__PURE__*/_react.default.memo(ExceptionsAddToListsComponent);
exports.ExceptionsAddToListsTable = ExceptionsAddToListsTable;
ExceptionsAddToListsTable.displayName = 'ExceptionsAddToListsTable';