"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToListsOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_to_lists_table = require("../add_to_lists_table");
var _kibana = require("../../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsAddToListsOptionsComponent = ({
  rulesCount,
  selectedRadioOption,
  sharedLists,
  onListsSelectionChange,
  onRadioChange
}) => {
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const onPopOverButtonClick = () => setIsPopoverOpen(!isPopoverOpen);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: "add_to_lists",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      gutterSize: "none",
      responsive: false,
      "data-test-subj": "addToListsRadioOptionLabel"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.ADD_TO_LISTS_OPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "addToListsOption"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "iInCircle",
        onClick: onPopOverButtonClick
      }),
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      anchorPosition: "upCenter"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '300px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, sharedLists.length === 0 ? i18n.ADD_TO_LISTS_OPTION_DISABLED_TOOLTIP(rulesCount) : i18n.ADD_TO_LISTS_OPTION_TOOLTIP)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      iconType: "popout",
      iconSide: "right",
      onClick: () => navigateToApp('security', {
        openInNewTab: true,
        path: '/exceptions'
      })
    }, i18n.GO_TO_EXCEPTIONS))))),
    checked: selectedRadioOption === 'add_to_lists',
    disabled: sharedLists.length === 0 && rulesCount > 0,
    onChange: () => onRadioChange('add_to_lists'),
    "data-test-subj": "addToListsRadioOption"
  }), selectedRadioOption === 'add_to_lists' && (sharedLists.length > 0 || rulesCount === 0) && /*#__PURE__*/_react.default.createElement(_add_to_lists_table.ExceptionsAddToListsTable, {
    showAllSharedLists: rulesCount === 0,
    sharedExceptionLists: sharedLists,
    onListSelectionChange: onListsSelectionChange,
    "data-test-subj": "exceptionsAddToListTable"
  }));
};
const ExceptionsAddToListsOptions = /*#__PURE__*/_react.default.memo(ExceptionsAddToListsOptionsComponent);
exports.ExceptionsAddToListsOptions = ExceptionsAddToListsOptions;
ExceptionsAddToListsOptions.displayName = 'ExceptionsAddToListsOptions';