"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exceptionItemCommentsAccordion = exports.OS_WINDOWS = exports.OS_MAC = exports.OS_LINUX = exports.EXCEPTION_ITEM_UPDATED_LABEL = exports.EXCEPTION_ITEM_META_BY = exports.EXCEPTION_ITEM_EXPIRES_LABEL = exports.EXCEPTION_ITEM_EXPIRED_LABEL = exports.EXCEPTION_ITEM_EDIT_BUTTON = exports.EXCEPTION_ITEM_DELETE_BUTTON = exports.EXCEPTION_ITEM_CREATED_LABEL = exports.ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON = exports.ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON = exports.CONDITION_OS = exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = exports.CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NOT_IN_LIST = exports.CONDITION_OPERATOR_TYPE_NESTED = exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_MATCH = exports.CONDITION_OPERATOR_TYPE_LIST = exports.CONDITION_OPERATOR_TYPE_EXISTS = exports.CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST = exports.CONDITION_AND = exports.AFFECTED_RULES = exports.AFFECTED_LIST = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCEPTION_ITEM_EDIT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.editItemButton', {
  defaultMessage: 'Edit rule exception'
});
exports.EXCEPTION_ITEM_EDIT_BUTTON = EXCEPTION_ITEM_EDIT_BUTTON;
const EXCEPTION_ITEM_DELETE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.deleteItemButton', {
  defaultMessage: 'Delete rule exception'
});
exports.EXCEPTION_ITEM_DELETE_BUTTON = EXCEPTION_ITEM_DELETE_BUTTON;
const ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.endpoint.editItemButton', {
  defaultMessage: 'Edit endpoint exception'
});
exports.ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON = ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON;
const ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.endpoint.deleteItemButton', {
  defaultMessage: 'Delete endpoint exception'
});
exports.ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON = ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON;
const EXCEPTION_ITEM_CREATED_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.createdLabel', {
  defaultMessage: 'Created'
});
exports.EXCEPTION_ITEM_CREATED_LABEL = EXCEPTION_ITEM_CREATED_LABEL;
const EXCEPTION_ITEM_UPDATED_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.updatedLabel', {
  defaultMessage: 'Updated'
});
exports.EXCEPTION_ITEM_UPDATED_LABEL = EXCEPTION_ITEM_UPDATED_LABEL;
const EXCEPTION_ITEM_EXPIRES_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.expiresLabel', {
  defaultMessage: 'Expires at'
});
exports.EXCEPTION_ITEM_EXPIRES_LABEL = EXCEPTION_ITEM_EXPIRES_LABEL;
const EXCEPTION_ITEM_EXPIRED_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.expiredLabel', {
  defaultMessage: 'Expired at'
});
exports.EXCEPTION_ITEM_EXPIRED_LABEL = EXCEPTION_ITEM_EXPIRED_LABEL;
const EXCEPTION_ITEM_META_BY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.metaDetailsBy', {
  defaultMessage: 'by'
});
exports.EXCEPTION_ITEM_META_BY = EXCEPTION_ITEM_META_BY;
const exceptionItemCommentsAccordion = comments => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.showCommentsLabel', {
  values: {
    comments
  },
  defaultMessage: 'Show {comments, plural, =1 {comment} other {comments}} ({comments})'
});
exports.exceptionItemCommentsAccordion = exceptionItemCommentsAccordion;
const CONDITION_OPERATOR_TYPE_MATCH = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchOperator', {
  defaultMessage: 'IS'
});
exports.CONDITION_OPERATOR_TYPE_MATCH = CONDITION_OPERATOR_TYPE_MATCH;
const CONDITION_OPERATOR_TYPE_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchOperator.not', {
  defaultMessage: 'IS NOT'
});
exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = CONDITION_OPERATOR_TYPE_NOT_MATCH;
const CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.wildcardMatchesOperator', {
  defaultMessage: 'MATCHES'
});
exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES;
const CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.wildcardDoesNotMatchOperator', {
  defaultMessage: 'DOES NOT MATCH'
});
exports.CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH = CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH;
const CONDITION_OPERATOR_TYPE_NESTED = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.nestedOperator', {
  defaultMessage: 'has'
});
exports.CONDITION_OPERATOR_TYPE_NESTED = CONDITION_OPERATOR_TYPE_NESTED;
const CONDITION_OPERATOR_TYPE_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchAnyOperator', {
  defaultMessage: 'is one of'
});
exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = CONDITION_OPERATOR_TYPE_MATCH_ANY;
const CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchAnyOperator.not', {
  defaultMessage: 'is not one of'
});
exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY;
const CONDITION_OPERATOR_TYPE_EXISTS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.existsOperator', {
  defaultMessage: 'exists'
});
exports.CONDITION_OPERATOR_TYPE_EXISTS = CONDITION_OPERATOR_TYPE_EXISTS;
const CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.existsOperator.not', {
  defaultMessage: 'does not exist'
});
exports.CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST = CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST;
const CONDITION_OPERATOR_TYPE_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.listOperator', {
  defaultMessage: 'included in'
});
exports.CONDITION_OPERATOR_TYPE_LIST = CONDITION_OPERATOR_TYPE_LIST;
const CONDITION_OPERATOR_TYPE_NOT_IN_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.listOperator.not', {
  defaultMessage: 'is not included in'
});
exports.CONDITION_OPERATOR_TYPE_NOT_IN_LIST = CONDITION_OPERATOR_TYPE_NOT_IN_LIST;
const CONDITION_AND = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.and', {
  defaultMessage: 'AND'
});
exports.CONDITION_AND = CONDITION_AND;
const CONDITION_OS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.os', {
  defaultMessage: 'OS'
});
exports.CONDITION_OS = CONDITION_OS;
const OS_WINDOWS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.windows', {
  defaultMessage: 'Windows'
});
exports.OS_WINDOWS = OS_WINDOWS;
const OS_LINUX = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.linux', {
  defaultMessage: 'Linux'
});
exports.OS_LINUX = OS_LINUX;
const OS_MAC = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.macos', {
  defaultMessage: 'Mac'
});
exports.OS_MAC = OS_MAC;
const AFFECTED_RULES = numRules => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.affectedRules', {
  values: {
    numRules
  },
  defaultMessage: 'Affects {numRules} {numRules, plural, =1 {rule} other {rules}}'
});
exports.AFFECTED_RULES = AFFECTED_RULES;
const AFFECTED_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.affectedList', {
  defaultMessage: 'Affects shared list'
});
exports.AFFECTED_LIST = AFFECTED_LIST;