"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsViewerSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ITEMS_SCHEMA = {
  strict: true,
  fields: {
    created_by: {
      type: 'string'
    },
    description: {
      type: 'string'
    },
    id: {
      type: 'string'
    },
    item_id: {
      type: 'string'
    },
    list_id: {
      type: 'string'
    },
    name: {
      type: 'string'
    },
    os_types: {
      type: 'string'
    },
    tags: {
      type: 'string'
    }
  }
};
/**
 * Search exception items and take actions (to creat an item)
 */
const ExceptionsViewerSearchBarComponent = ({
  canAddException,
  isEndpoint,
  isSearching,
  onSearch,
  onAddExceptionClick
}) => {
  const handleOnSearch = (0, _react.useCallback)(({
    queryText
  }) => {
    onSearch({
      search: queryText
    });
  }, [onSearch]);
  const handleAddException = (0, _react.useCallback)(() => {
    onAddExceptionClick();
  }, [onAddExceptionClick]);
  const addExceptionButtonText = (0, _react.useMemo)(() => {
    return isEndpoint ? i18n.ADD_TO_ENDPOINT_LIST : i18n.ADD_TO_DETECTIONS_LIST;
  }, [isEndpoint]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      placeholder: i18n.SEARCH_PLACEHOLDER,
      incremental: true,
      schema: ITEMS_SCHEMA,
      'data-test-subj': 'exceptionsViewerSearchBar'
    },
    filters: [],
    onChange: handleOnSearch
  })), !canAddException && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "exceptionsHeaderAddExceptionBtn",
    onClick: handleAddException,
    isDisabled: isSearching,
    fill: true
  }, addExceptionButtonText)));
};
ExceptionsViewerSearchBarComponent.displayName = 'ExceptionsViewerSearchBarComponent';
const ExceptionsViewerSearchBar = /*#__PURE__*/_react.default.memo(ExceptionsViewerSearchBarComponent);
exports.ExceptionsViewerSearchBar = ExceptionsViewerSearchBar;
ExceptionsViewerSearchBar.displayName = 'ExceptionsViewerSearchBar';