"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExeptionItemsViewerEmptyPrompts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _illustration_product_no_results_magnifying_glass = _interopRequireDefault(require("../../../../common/images/illustration_product_no_results_magnifying_glass.svg"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExeptionItemsViewerEmptyPromptsComponent = ({
  isReadOnly,
  isEndpoint,
  currentState,
  onCreateExceptionListItem
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const content = (0, _react.useMemo)(() => {
    switch (currentState) {
      case 'error':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          color: 'danger',
          iconType: 'error',
          title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.EXCEPTION_ERROR_TITLE),
          body: /*#__PURE__*/_react.default.createElement("p", null, i18n.EXCEPTION_ERROR_DESCRIPTION),
          "data-test-subj": 'exceptionItemViewerEmptyPrompts-error'
        });
      case 'empty':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          color: 'subdued',
          iconType: 'plusInCircle',
          iconColor: euiTheme.colors.darkestShade,
          title: /*#__PURE__*/_react.default.createElement("h2", {
            "data-test-subj": "exceptionsEmptyPromptTitle"
          }, i18n.EXCEPTION_EMPTY_PROMPT_TITLE),
          body: /*#__PURE__*/_react.default.createElement("p", {
            "data-test-subj": "exceptionsEmptyPromptBody"
          }, isEndpoint ? i18n.EXCEPTION_EMPTY_ENDPOINT_PROMPT_BODY : i18n.EXCEPTION_EMPTY_PROMPT_BODY),
          actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": "exceptionsEmptyPromptButton",
            onClick: onCreateExceptionListItem,
            iconType: "plusInCircle",
            color: "primary",
            isDisabled: isReadOnly,
            fill: true
          }, isEndpoint ? i18n.EXCEPTION_EMPTY_PROMPT_ENDPOINT_BUTTON : i18n.EXCEPTION_EMPTY_PROMPT_BUTTON)],
          "data-test-subj": "exceptionItemViewerEmptyPrompts-empty"
        });
      case 'empty_search':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          color: 'plain',
          layout: 'horizontal',
          hasBorder: true,
          hasShadow: false,
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
            size: "fullWidth",
            alt: "",
            url: _illustration_product_no_results_magnifying_glass.default
          }),
          title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_TITLE),
          body: /*#__PURE__*/_react.default.createElement("p", null, i18n.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_BODY),
          "data-test-subj": "exceptionItemViewerEmptyPrompts-emptySearch"
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
          lines: 4,
          "data-test-subj": "exceptionItemViewerEmptyPrompts-loading"
        });
    }
  }, [currentState, euiTheme.colors.darkestShade, isReadOnly, isEndpoint, onCreateExceptionListItem]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    color: currentState === 'empty_search' ? 'subdued' : 'transparent',
    style: {
      margin: `${euiTheme.size.l} 0`,
      padding: `${euiTheme.size.l} 0`
    }
  }, content);
};
const ExeptionItemsViewerEmptyPrompts = /*#__PURE__*/_react.default.memo(ExeptionItemsViewerEmptyPromptsComponent);
exports.ExeptionItemsViewerEmptyPrompts = ExeptionItemsViewerEmptyPrompts;
ExeptionItemsViewerEmptyPrompts.displayName = 'ExeptionItemsViewerEmptyPrompts';