"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddNewExceptionItems = void 0;
var _react = require("react");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_create_update_exception = require("../../logic/use_create_update_exception");
var _use_add_rule_exception = require("../../logic/use_add_rule_exception");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for adding new exception items from flyout
 *
 */
const useAddNewExceptionItems = () => {
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const [isAddRuleExceptionLoading, addRuleExceptions] = (0, _use_add_rule_exception.useAddRuleDefaultException)();
  const [isAddingExceptions, addSharedExceptions] = (0, _use_create_update_exception.useCreateOrUpdateException)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const addNewExceptionsRef = (0, _react.useRef)(null);
  const areRuleDefaultItems = (0, _react.useCallback)(items => {
    return items.every(item => _securitysolutionIoTsListTypes.createRuleExceptionListItemSchema.is(item));
  }, []);
  const areSharedListItems = (0, _react.useCallback)(items => {
    return items.every(item => _securitysolutionIoTsListTypes.exceptionListItemSchema.is(item) || _securitysolutionIoTsListTypes.createExceptionListItemSchema.is(item));
  }, []);
  (0, _react.useEffect)(() => {
    const abortCtrl = new AbortController();
    const addNewExceptions = async ({
      itemsToAdd,
      listType,
      selectedRulesToAddTo,
      addToRules,
      addToSharedLists,
      sharedLists
    }) => {
      try {
        let result = [];
        setIsLoading(true);
        if (addToRules && addRuleExceptions != null && listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT && areRuleDefaultItems(itemsToAdd)) {
          result = await addRuleExceptions(itemsToAdd, selectedRulesToAddTo);
          const ruleNames = selectedRulesToAddTo.map(({
            name
          }) => name).join(', ');
          addSuccess({
            title: i18n.ADD_RULE_EXCEPTION_SUCCESS_TITLE,
            text: i18n.ADD_RULE_EXCEPTION_SUCCESS_TEXT(ruleNames)
          });
        } else if ((listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT || addToSharedLists) && addSharedExceptions != null && areSharedListItems(itemsToAdd)) {
          result = await addSharedExceptions(itemsToAdd);
          const sharedListNames = sharedLists.map(({
            name
          }) => name);
          addSuccess({
            title: i18n.ADD_EXCEPTION_SUCCESS,
            text: i18n.ADD_EXCEPTION_SUCCESS_DETAILS(sharedListNames.join(','))
          });
        }
        setIsLoading(false);
        return result;
      } catch (e) {
        setIsLoading(false);
        addError(e, {
          title: i18n.SUBMIT_ERROR_TITLE
        });
        throw e;
      }
    };
    addNewExceptionsRef.current = addNewExceptions;
    return () => {
      abortCtrl.abort();
    };
  }, [addSuccess, addError, addWarning, addRuleExceptions, addSharedExceptions, areRuleDefaultItems, areSharedListItems]);
  return [isLoading || isAddingExceptions || isAddRuleExceptionLoading, addNewExceptionsRef.current];
};
exports.useAddNewExceptionItems = useAddNewExceptionItems;