"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsPage = exports.RuleDetailTabs = exports.RULE_DETAILS_TAB_NAME = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _public = require("@kbn/timelines-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _alerts_table = require("../../../../detections/components/alerts_table");
var _alerts_grouping = require("../../../../detections/components/alerts_table/alerts_grouping");
var _use_data_table_filters = require("../../../../common/hooks/use_data_table_filters");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _tab_navigation_with_breadcrumbs = require("../../../../common/components/navigation/tab_navigation_with_breadcrumbs");
var _constants = require("../../../../common/store/inputs/constants");
var _use_selector = require("../../../../common/hooks/use_selector");
var _kibana = require("../../../../common/lib/kibana");
var _filters_global = require("../../../../common/components/filters_global");
var _formatted_date = require("../../../../common/components/formatted_date");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _search_bar = require("../../../../common/components/search_bar");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _step_about_rule_details = require("../../../../detections/components/rules/step_about_rule_details");
var _alerts_histogram_panel = require("../../../../detections/components/alerts_kpis/alerts_histogram_panel");
var _user_info = require("../../../../detections/components/user_info");
var _step_define_rule = require("../../../../detections/components/rules/step_define_rule");
var _step_schedule_rule = require("../../../../detections/components/rules/step_schedule_rule");
var _default_config = require("../../../../detections/components/alerts_table/default_config");
var _rule_switch = require("../../../../detections/components/rules/rule_switch");
var _step_panel = require("../../../../detections/components/rules/step_panel");
var _helpers2 = require("../../../../detections/pages/detection_engine/rules/helpers");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _inputs = require("../../../../common/store/inputs");
var _actions = require("../../../../common/store/inputs/actions");
var _rule_actions_overflow = require("../../../../detections/components/rules/rule_actions_overflow");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _types = require("../../../../app/types");
var _constants2 = require("../../../../../common/constants");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _display = require("../../../../explore/hosts/pages/display");
var _helpers3 = require("../../../../timelines/components/timeline/helpers");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _model = require("../../../../common/store/sourcerer/model");
var _privileges = require("../../../../common/utils/privileges");
var _rule_execution_status = require("../../../../detections/components/rules/rule_execution_status");
var _rule_monitoring = require("../../../rule_monitoring");
var _execution_log_table = require("./execution_log_table/execution_log_table");
var detectionI18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/translations"));
var ruleI18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _rule_details_context = require("./rule_details_context");
var _use_get_saved_query = require("../../../../detections/pages/detection_engine/rules/use_get_saved_query");
var i18n = _interopRequireWildcard(require("./translations"));
var _need_admin_for_update_callout = require("../../../../detections/components/callouts/need_admin_for_update_callout");
var _missing_privileges_callout = require("../../../../detections/components/callouts/missing_privileges_callout");
var _use_rule_with_fallback = require("../../../rule_management/logic/use_rule_with_fallback");
var _alerts_filter_group = require("../../../../detections/components/alerts_table/alerts_filter_group");
var _use_signal_helpers = require("../../../../common/containers/sourcerer/use_signal_helpers");
var _header_page = require("../../../../common/components/header_page");
var _all_exception_items_table = require("../../../rule_exceptions/components/all_exception_items_table");
var _edit_rule_settings_button_link = require("../../../../detections/pages/detection_engine/rules/details/components/edit_rule_settings_button_link");
var _use_start_ml_jobs = require("../../../rule_management/logic/use_start_ml_jobs");
var _use_bulk_duplicate_confirmation = require("../../../rule_management_ui/components/rules_table/bulk_actions/use_bulk_duplicate_confirmation");
var _bulk_duplicate_exceptions_confirmation = require("../../../rule_management_ui/components/rules_table/bulk_actions/bulk_duplicate_exceptions_confirmation");
var _rule_snooze_badge = require("../../../rule_management/components/rule_snooze_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */
// TODO: Disabling complexity is temporary till this component is refactored as part of lists UI integration

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;

/**
 * Sets min-height on tab container to minimize page hop when switching to tabs with less content
 */
const StyledMinHeightTabContainer = _styledComponents.default.div`
  min-height: 800px;
`;
let RuleDetailTabs;
exports.RuleDetailTabs = RuleDetailTabs;
(function (RuleDetailTabs) {
  RuleDetailTabs["alerts"] = "alerts";
  RuleDetailTabs["exceptions"] = "rule_exceptions";
  RuleDetailTabs["endpointExceptions"] = "endpoint_exceptions";
  RuleDetailTabs["executionResults"] = "execution_results";
  RuleDetailTabs["executionEvents"] = "execution_events";
})(RuleDetailTabs || (exports.RuleDetailTabs = RuleDetailTabs = {}));
const RULE_DETAILS_TAB_NAME = {
  [RuleDetailTabs.alerts]: detectionI18n.ALERT,
  [RuleDetailTabs.exceptions]: i18n.EXCEPTIONS_TAB,
  [RuleDetailTabs.endpointExceptions]: i18n.ENDPOINT_EXCEPTIONS_TAB,
  [RuleDetailTabs.executionResults]: i18n.EXECUTION_RESULTS_TAB,
  [RuleDetailTabs.executionEvents]: i18n.EXECUTION_EVENTS_TAB
};
exports.RULE_DETAILS_TAB_NAME = RULE_DETAILS_TAB_NAME;
const RuleDetailsPageComponent = ({
  clearEventsDeleted,
  clearEventsLoading,
  clearSelected
}) => {
  var _rule$execution_summa, _lastExecution$date, _lastExecution$messag, _rule$id, _rule$enabled;
  const {
    data,
    application: {
      navigateToApp,
      capabilities: {
        actions
      }
    },
    timelines: timelinesUi,
    spaces: spacesApi
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const containerElement = (0, _react.useRef)(null);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const graphEventId = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).graphEventId;
  });
  const updatedAt = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable2;
    return ((_getTable2 = getTable(state, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage)) !== null && _getTable2 !== void 0 ? _getTable2 : _securitysolutionDataTable.tableDefaults).updated;
  });
  const isAlertsLoading = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable3;
    return ((_getTable3 = getTable(state, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage)) !== null && _getTable3 !== void 0 ? _getTable3 : _securitysolutionDataTable.tableDefaults).isLoading;
  });
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD,
    hasIndexRead,
    signalIndexName,
    hasIndexWrite,
    hasIndexMaintenance
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    indexPattern,
    runtimeMappings,
    loading: isLoadingIndexPattern
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const loading = userInfoLoading || listsConfigLoading;
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    rule: maybeRule,
    refresh: refreshRule,
    loading: ruleLoading,
    isExistingRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const {
    pollForSignalIndex
  } = (0, _use_signal_helpers.useSignalHelpers)();
  const [rule, setRule] = (0, _react.useState)(null);
  const isLoading = ruleLoading && rule == null;
  const {
    starting: isStartingJobs,
    startMlJobs
  } = (0, _use_start_ml_jobs.useStartMlJobs)();
  const startMlJobsIfNeeded = (0, _react.useCallback)(async () => {
    await startMlJobs(rule === null || rule === void 0 ? void 0 : rule.machine_learning_job_id);
  }, [rule, startMlJobs]);
  const ruleDetailTabs = (0, _react.useMemo)(() => ({
    [RuleDetailTabs.alerts]: {
      id: RuleDetailTabs.alerts,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.alerts],
      disabled: false,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.alerts}`
    },
    [RuleDetailTabs.exceptions]: {
      id: RuleDetailTabs.exceptions,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.exceptions],
      disabled: rule == null,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.exceptions}`
    },
    [RuleDetailTabs.endpointExceptions]: {
      id: RuleDetailTabs.endpointExceptions,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.endpointExceptions],
      disabled: rule == null,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.endpointExceptions}`
    },
    [RuleDetailTabs.executionResults]: {
      id: RuleDetailTabs.executionResults,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.executionResults],
      disabled: !isExistingRule,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.executionResults}`
    },
    [RuleDetailTabs.executionEvents]: {
      id: RuleDetailTabs.executionEvents,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.executionEvents],
      disabled: !isExistingRule,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.executionEvents}`
    }
  }), [isExistingRule, rule, ruleId]);
  const [pageTabs, setTabs] = (0, _react.useState)(ruleDetailTabs);
  const {
    aboutRuleData,
    modifiedAboutRuleDetailsData,
    defineRuleData,
    scheduleRuleData
  } = rule != null ? (0, _helpers2.getStepsData)({
    rule,
    detailsView: true
  }) : {
    aboutRuleData: null,
    modifiedAboutRuleDetailsData: null,
    defineRuleData: null,
    scheduleRuleData: null
  };
  const [dataViewTitle, setDataViewTitle] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const fetchDataViewTitle = async () => {
      if ((defineRuleData === null || defineRuleData === void 0 ? void 0 : defineRuleData.dataViewId) != null && (defineRuleData === null || defineRuleData === void 0 ? void 0 : defineRuleData.dataViewId) !== '') {
        const dataView = await data.dataViews.get(defineRuleData === null || defineRuleData === void 0 ? void 0 : defineRuleData.dataViewId);
        setDataViewTitle(dataView.title);
      }
    };
    fetchDataViewTitle();
  }, [data.dataViews, defineRuleData === null || defineRuleData === void 0 ? void 0 : defineRuleData.dataViewId]);
  const {
    showBuildingBlockAlerts,
    setShowBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts
  } = (0, _use_data_table_filters.useDataTableFilters)(_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage);
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const [filterGroup, setFilterGroup] = (0, _react.useState)(_securitysolutionDataTable.FILTER_OPEN);
  const [dataViewOptions, setDataViewOptions] = (0, _react.useState)({});
  const {
    isSavedQueryLoading,
    savedQueryBar
  } = (0, _use_get_saved_query.useGetSavedQuery)(rule === null || rule === void 0 ? void 0 : rule.saved_id, {
    ruleType: rule === null || rule === void 0 ? void 0 : rule.type
  });
  const [indicesConfig] = (0, _kibana.useUiSetting$)(_constants2.DEFAULT_INDEX_KEY);
  const [threatIndicesConfig] = (0, _kibana.useUiSetting$)(_constants2.DEFAULT_THREAT_INDEX_KEY);
  (0, _react.useEffect)(() => {
    const fetchDV = async () => {
      const dataViewsRefs = await data.dataViews.getIdsWithTitle();
      const dataViewIdIndexPatternMap = dataViewsRefs.reduce((acc, item) => ({
        ...acc,
        [item.id]: item
      }), {});
      setDataViewOptions(dataViewIdIndexPatternMap);
    };
    fetchDV();
    // if this array is not empty the data.dataViews dependency
    // causes the jest tests for this file to re-render the
    // step_define_rule component infinitely for some reason.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // TODO: Refactor license check + hasMlAdminPermissions to common check
  const hasMlPermissions = (0, _has_ml_license.hasMlLicense)(mlCapabilities) && (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities);
  const hasActionsPrivileges = (0, _react.useMemo)(() => {
    if ((rule === null || rule === void 0 ? void 0 : rule.actions) != null && (rule === null || rule === void 0 ? void 0 : rule.actions.length) > 0 && (0, _privileges.isBoolean)(actions.show)) {
      return actions.show;
    }
    return true;
  }, [actions, rule === null || rule === void 0 ? void 0 : rule.actions]);
  const navigateToAlertsTab = (0, _react.useCallback)(() => {
    navigateToApp(_constants2.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '', 'alerts', '')
    });
  }, [navigateToApp, ruleId]);

  // persist rule until refresh is complete
  (0, _react.useEffect)(() => {
    if (maybeRule != null) {
      setRule(maybeRule);
    }
  }, [maybeRule]);
  (0, _react.useEffect)(() => {
    if (rule) {
      const outcome = rule.outcome;
      if (spacesApi && outcome === 'aliasMatch') {
        // This rule has been resolved from a legacy URL - redirect the user to the new URL and display a toast.
        const path = `rules/id/${rule.id}${window.location.search}${window.location.hash}`;
        spacesApi.ui.redirectLegacyUrl({
          path,
          aliasPurpose: rule.alias_purpose,
          objectNoun: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.redirectObjectNoun', {
            defaultMessage: 'rule'
          })
        });
      }
    }
  }, [rule, spacesApi]);
  const getLegacyUrlConflictCallout = (0, _react.useMemo)(() => {
    if ((rule === null || rule === void 0 ? void 0 : rule.alias_target_id) != null && spacesApi && rule.outcome === 'conflict') {
      const aliasTargetId = rule.alias_target_id;
      // We have resolved to one rule, but there is another one with a legacy URL associated with this page. Display a
      // callout with a warning for the user, and provide a way for them to navigate to the other rule.
      const otherRulePath = `rules/id/${aliasTargetId}${window.location.search}${window.location.hash}`;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), spacesApi.ui.components.getLegacyUrlConflict({
        objectNoun: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.redirectObjectNoun', {
          defaultMessage: 'rule'
        }),
        currentObjectId: rule.id,
        otherObjectId: aliasTargetId,
        otherObjectPath: otherRulePath
      }));
    }
    return null;
  }, [rule, spacesApi]);
  const ruleExecutionSettings = (0, _rule_monitoring.useRuleExecutionSettings)();
  (0, _react.useEffect)(() => {
    const hiddenTabs = [];
    if (!hasIndexRead) {
      hiddenTabs.push(RuleDetailTabs.alerts);
    }
    if (!ruleExecutionSettings.extendedLogging.isEnabled) {
      hiddenTabs.push(RuleDetailTabs.executionEvents);
    }
    if (rule != null) {
      var _rule$exceptions_list;
      const hasEndpointList = ((_rule$exceptions_list = rule.exceptions_list) !== null && _rule$exceptions_list !== void 0 ? _rule$exceptions_list : []).some(list => list.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT);
      if (!hasEndpointList) {
        hiddenTabs.push(RuleDetailTabs.endpointExceptions);
      }
    }
    const tabs = (0, _fp.omit)(hiddenTabs, ruleDetailTabs);
    setTabs(tabs);
  }, [hasIndexRead, rule, ruleDetailTabs, ruleExecutionSettings]);
  const showUpdating = (0, _react.useMemo)(() => isLoadingIndexPattern || isAlertsLoading || loading, [isLoadingIndexPattern, isAlertsLoading, loading]);
  const title = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rule === null || rule === void 0 ? void 0 : rule.name, " ", ruleLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), [rule, ruleLoading]);
  const badgeOptions = (0, _react.useMemo)(() => !ruleLoading && !isExistingRule ? {
    text: i18n.DELETED_RULE,
    color: 'default'
  } : undefined, [isExistingRule, ruleLoading]);
  const subTitle = (0, _react.useMemo)(() => {
    var _rule$created_by, _rule$created_at, _rule$updated_by, _rule$updated_at;
    return rule ? [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.ruleDetails.ruleCreationDescription",
      defaultMessage: "Created by: {by} on {date}",
      values: {
        by: (_rule$created_by = rule === null || rule === void 0 ? void 0 : rule.created_by) !== null && _rule$created_by !== void 0 ? _rule$created_by : i18n.UNKNOWN,
        date: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
          value: (_rule$created_at = rule === null || rule === void 0 ? void 0 : rule.created_at) !== null && _rule$created_at !== void 0 ? _rule$created_at : new Date().toISOString(),
          fieldName: "createdAt"
        })
      }
    }), (rule === null || rule === void 0 ? void 0 : rule.updated_by) != null ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.ruleDetails.ruleUpdateDescription",
      defaultMessage: "Updated by: {by} on {date}",
      values: {
        by: (_rule$updated_by = rule === null || rule === void 0 ? void 0 : rule.updated_by) !== null && _rule$updated_by !== void 0 ? _rule$updated_by : i18n.UNKNOWN,
        date: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
          value: (_rule$updated_at = rule === null || rule === void 0 ? void 0 : rule.updated_at) !== null && _rule$updated_at !== void 0 ? _rule$updated_at : new Date().toISOString(),
          fieldName: "updatedAt"
        })
      }
    }) : ''] : ruleLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    }) : null;
  }, [rule, ruleLoading]);

  // Callback for when open/closed filter changes
  const onFilterGroupChangedCallback = (0, _react.useCallback)(newFilterGroup => {
    const tableId = _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage;
    clearEventsLoading({
      id: tableId
    });
    clearEventsDeleted({
      id: tableId
    });
    clearSelected({
      id: tableId
    });
    setFilterGroup(newFilterGroup);
  }, [clearEventsLoading, clearEventsDeleted, clearSelected, setFilterGroup]);

  // Set showBuildingBlockAlerts if rule is a Building Block Rule otherwise we won't show alerts
  (0, _react.useEffect)(() => {
    setShowBuildingBlockAlerts((rule === null || rule === void 0 ? void 0 : rule.building_block_type) != null);
  }, [rule, setShowBuildingBlockAlerts]);
  const alertDefaultFilters = (0, _react.useMemo)(() => {
    var _rule$rule_id;
    return [...(0, _default_config.buildAlertsFilter)((_rule$rule_id = rule === null || rule === void 0 ? void 0 : rule.rule_id) !== null && _rule$rule_id !== void 0 ? _rule$rule_id : ''), ...(0, _default_config.buildShowBuildingBlockFilter)(showBuildingBlockAlerts), ...(0, _default_config.buildAlertStatusFilter)(filterGroup), ...(0, _default_config.buildThreatMatchFilter)(showOnlyThreatIndicatorAlerts)];
  }, [rule, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, filterGroup]);
  const alertMergedFilters = (0, _react.useMemo)(() => [...alertDefaultFilters, ...filters], [alertDefaultFilters, filters]);
  const lastExecution = rule === null || rule === void 0 ? void 0 : (_rule$execution_summa = rule.execution_summary) === null || _rule$execution_summa === void 0 ? void 0 : _rule$execution_summa.last_execution;
  const lastExecutionStatus = lastExecution === null || lastExecution === void 0 ? void 0 : lastExecution.status;
  const lastExecutionDate = (_lastExecution$date = lastExecution === null || lastExecution === void 0 ? void 0 : lastExecution.date) !== null && _lastExecution$date !== void 0 ? _lastExecution$date : '';
  const lastExecutionMessage = (_lastExecution$messag = lastExecution === null || lastExecution === void 0 ? void 0 : lastExecution.message) !== null && _lastExecution$messag !== void 0 ? _lastExecution$messag : '';
  const ruleStatusInfo = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "rule-status-loader"
    })) : /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatus, {
      status: lastExecutionStatus,
      date: lastExecutionDate
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "refreshButton",
      color: "primary",
      onClick: refreshRule,
      iconType: "refresh",
      "aria-label": ruleI18n.REFRESH,
      isDisabled: !isExistingRule
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_rule_snooze_badge.RuleSnoozeBadge, {
      ruleId: ruleId,
      showTooltipInline: true
    })));
  }, [ruleId, lastExecutionStatus, lastExecutionDate, ruleLoading, isExistingRule, refreshRule]);
  const ruleError = (0, _react.useMemo)(() => {
    return ruleLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "rule-status-loader"
    })) : /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatusFailedCallOut, {
      status: lastExecutionStatus,
      date: lastExecutionDate,
      message: lastExecutionMessage
    });
  }, [lastExecutionStatus, lastExecutionDate, lastExecutionMessage, ruleLoading]);
  const updateDateRangeCallback = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch]);
  const handleOnChangeEnabledRule = (0, _react.useCallback)(enabled => {
    setRule(currentRule => currentRule ? {
      ...currentRule,
      enabled
    } : currentRule);
  }, []);
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers3.focusUtilityBarAction)(containerElement.current);
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers3.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers3.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const renderGroupedAlertTable = (0, _react.useCallback)(groupingFilters => {
    return /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTableComponent, {
      configId: _constants2.ALERTS_TABLE_REGISTRY_CONFIG_IDS.RULE_DETAILS,
      flyoutSize: "m",
      inputFilters: [...alertMergedFilters, ...groupingFilters],
      tableId: _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage,
      onRuleChange: refreshRule
    });
  }, [alertMergedFilters, refreshRule]);
  const {
    isBulkDuplicateConfirmationVisible,
    showBulkDuplicateConfirmation,
    cancelRuleDuplication,
    confirmRuleDuplication
  } = (0, _use_bulk_duplicate_confirmation.useBulkDuplicateExceptionsConfirmation)();
  if ((0, _helpers2.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants2.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  }
  const defaultRuleStackByOption = 'event.category';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_need_admin_for_update_callout.NeedAdminForUpdateRulesCallOut, null), /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallOut, null), isBulkDuplicateConfirmationVisible && /*#__PURE__*/_react.default.createElement(_bulk_duplicate_exceptions_confirmation.BulkActionDuplicateExceptionsConfirmation, {
    onCancel: cancelRuleDuplication,
    onConfirm: confirmRuleDuplication,
    rulesCount: 1
  }), /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    show: (0, _helpers3.showGlobalFilters)({
      globalFullScreen,
      graphEventId
    })
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    pollForSignalIndex: pollForSignalIndex,
    indexPattern: indexPattern
  })), /*#__PURE__*/_react.default.createElement(_rule_details_context.RuleDetailsContextProvider, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    subtitle: subTitle,
    subtitle2: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      justifyContent: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _rule_execution_status.ruleStatusI18n.STATUS, ':'), ruleStatusInfo)),
    title: title,
    badgeOptions: badgeOptions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: (0, _privileges.explainLackOfPermission)(rule, hasMlPermissions, hasActionsPrivileges, canUserCRUD)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_rule_switch.RuleSwitch, {
    id: (_rule$id = rule === null || rule === void 0 ? void 0 : rule.id) !== null && _rule$id !== void 0 ? _rule$id : '-1',
    isDisabled: !isExistingRule || !(0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges) || !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || (0, _helpers.isMlRule)(rule === null || rule === void 0 ? void 0 : rule.type) && !hasMlPermissions,
    enabled: isExistingRule && ((_rule$enabled = rule === null || rule === void 0 ? void 0 : rule.enabled) !== null && _rule$enabled !== void 0 ? _rule$enabled : false),
    startMlJobsIfNeeded: startMlJobsIfNeeded,
    onChange: handleOnChangeEnabledRule
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.ENABLE_RULE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_edit_rule_settings_button_link.EditRuleSettingButtonLink, {
    ruleId: ruleId,
    disabled: !isExistingRule || !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || (0, _helpers.isMlRule)(rule === null || rule === void 0 ? void 0 : rule.type) && !hasMlPermissions,
    disabledReason: (0, _privileges.explainLackOfPermission)(rule, hasMlPermissions, hasActionsPrivileges, canUserCRUD)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_rule_actions_overflow.RuleActionsOverflow, {
    rule: rule,
    userHasPermissions: isExistingRule && (0, _privileges.hasUserCRUDPermission)(canUserCRUD),
    canDuplicateRuleWithActions: (0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges),
    showBulkDuplicateExceptionsConfirmation: showBulkDuplicateConfirmation
  })))))), ruleError, getLegacyUrlConflictCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "aboutRule",
    component: "section",
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_step_about_rule_details.StepAboutRuleToggleDetails, {
    loading: isLoading,
    stepData: aboutRuleData,
    stepDataDetails: modifiedAboutRuleDetailsData
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "section",
    grow: 1,
    "data-test-subj": "defineRule"
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    loading: isLoading || isSavedQueryLoading,
    title: ruleI18n.DEFINITION
  }, defineRuleData != null && !isSavedQueryLoading && !isStartingJobs && /*#__PURE__*/_react.default.createElement(_step_define_rule.StepDefineRule, {
    descriptionColumns: "singleSplit",
    isReadOnlyView: true,
    isLoading: false,
    defaultValues: {
      dataViewTitle,
      ...defineRuleData,
      queryBar: savedQueryBar !== null && savedQueryBar !== void 0 ? savedQueryBar : defineRuleData.queryBar
    },
    kibanaDataViews: dataViewOptions,
    indicesConfig: indicesConfig,
    threatIndicesConfig: threatIndicesConfig
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "schedule",
    component: "section",
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    loading: isLoading,
    title: ruleI18n.SCHEDULE
  }, scheduleRuleData != null && /*#__PURE__*/_react.default.createElement(_step_schedule_rule.StepScheduleRule, {
    descriptionColumns: "singleSplit",
    isReadOnlyView: true,
    isLoading: false,
    defaultValues: scheduleRuleData
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tab_navigation_with_breadcrumbs.TabNavigationWithBreadcrumbs, {
    navTabs: pageTabs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(StyledMinHeightTabContainer, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${RuleDetailTabs.alerts})`
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alerts_filter_group.AlertsTableFilterGroup, {
    status: filterGroup,
    onFilterGroupChanged: onFilterGroupChangedCallback
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, updatedAt && timelinesUi.getLastUpdated({
    updatedAt: updatedAt || Date.now(),
    showUpdating
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_alerts_histogram_panel.AlertsHistogramPanel, {
    filters: alertMergedFilters,
    query: query,
    signalIndexName: signalIndexName,
    defaultStackByOption: defaultRuleStackByOption,
    updateDateRange: updateDateRangeCallback,
    runtimeMappings: runtimeMappings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), ruleId != null && /*#__PURE__*/_react.default.createElement(_alerts_grouping.GroupedAlertsTable, {
    currentAlertStatusFilterValue: [filterGroup],
    defaultFilters: alertMergedFilters,
    from: from,
    globalFilters: filters,
    globalQuery: query,
    hasIndexMaintenance: hasIndexMaintenance !== null && hasIndexMaintenance !== void 0 ? hasIndexMaintenance : false,
    hasIndexWrite: hasIndexWrite !== null && hasIndexWrite !== void 0 ? hasIndexWrite : false,
    loading: loading,
    renderChildComponent: renderGroupedAlertTable,
    runtimeMappings: runtimeMappings,
    signalIndexName: signalIndexName,
    tableId: _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage,
    to: to
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${RuleDetailTabs.exceptions})`
  }, /*#__PURE__*/_react.default.createElement(_all_exception_items_table.ExceptionsViewer, {
    rule: rule,
    listTypes: [_securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION, _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT],
    onRuleChange: refreshRule,
    isViewReadOnly: !isExistingRule,
    "data-test-subj": "exceptionTab"
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${RuleDetailTabs.endpointExceptions})`
  }, /*#__PURE__*/_react.default.createElement(_all_exception_items_table.ExceptionsViewer, {
    rule: rule,
    listTypes: [_securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT],
    onRuleChange: refreshRule,
    isViewReadOnly: !isExistingRule,
    "data-test-subj": "endpointExceptionsTab"
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${RuleDetailTabs.executionResults})`
  }, /*#__PURE__*/_react.default.createElement(_execution_log_table.ExecutionLogTable, {
    ruleId: ruleId,
    selectAlertsTab: navigateToAlertsTab
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${RuleDetailTabs.executionEvents})`
  }, /*#__PURE__*/_react.default.createElement(_rule_monitoring.ExecutionEventsTable, {
    ruleId: ruleId
  }))))))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.rules,
    state: {
      ruleName: rule === null || rule === void 0 ? void 0 : rule.name,
      isExistingRule
    }
  }));
};
const mapDispatchToProps = dispatch => ({
  clearSelected: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearSelected({
    id
  })),
  clearEventsLoading: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearEventsLoading({
    id
  })),
  clearEventsDeleted: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearEventsDeleted({
    id
  }))
});
const connector = (0, _reactRedux.connect)(null, mapDispatchToProps);
RuleDetailsPageComponent.displayName = 'RuleDetailsPageComponent';
const RuleDetailsPage = connector( /*#__PURE__*/_react.default.memo(RuleDetailsPageComponent));
exports.RuleDetailsPage = RuleDetailsPage;
RuleDetailsPage.displayName = 'RuleDetailsPage';