"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRulePage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _rule_preview = require("../../../../detections/components/rules/rule_preview");
var _logic = require("../../../rule_management/logic");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _privileges = require("../../../../common/utils/privileges");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _toasters = require("../../../../common/components/toasters");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _user_info = require("../../../../detections/components/user_info");
var _step_panel = require("../../../../detections/components/rules/step_panel");
var _step_about_rule = require("../../../../detections/components/rules/step_about_rule");
var _step_define_rule = require("../../../../detections/components/rules/step_define_rule");
var _step_schedule_rule = require("../../../../detections/components/rules/step_schedule_rule");
var _step_rule_actions = require("../../../../detections/components/rules/step_rule_actions");
var _helpers = require("../rule_creation/helpers");
var _helpers2 = require("../../../../detections/pages/detection_engine/rules/helpers");
var ruleI18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _types = require("../../../../detections/pages/detection_engine/rules/types");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("../../../../app/types");
var _utils = require("../../../../detections/pages/detection_engine/rules/utils");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _header_page = require("../../../../common/components/header_page");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_get_saved_query = require("../../../../detections/pages/detection_engine/rules/use_get_saved_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formHookNoop = async () => undefined;
const EditRulePageComponent = () => {
  const [, dispatchToaster] = (0, _toasters.useStateToaster)();
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    data: dataServices
  } = (0, _kibana.useKibana)().services;
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    data: rule,
    isLoading: ruleLoading
  } = (0, _logic.useRule)(ruleId);
  const loading = ruleLoading || userInfoLoading || listsConfigLoading;
  const {
    isSavedQueryLoading,
    savedQueryBar,
    savedQuery
  } = (0, _use_get_saved_query.useGetSavedQuery)(rule === null || rule === void 0 ? void 0 : rule.saved_id, {
    ruleType: rule === null || rule === void 0 ? void 0 : rule.type,
    onError: _lodash.noop
  });
  const formHooks = (0, _react.useRef)({
    [_types.RuleStep.defineRule]: formHookNoop,
    [_types.RuleStep.aboutRule]: formHookNoop,
    [_types.RuleStep.scheduleRule]: formHookNoop,
    [_types.RuleStep.ruleActions]: formHookNoop
  });
  const stepsData = (0, _react.useRef)({
    [_types.RuleStep.defineRule]: {
      isValid: false,
      data: undefined
    },
    [_types.RuleStep.aboutRule]: {
      isValid: false,
      data: undefined
    },
    [_types.RuleStep.scheduleRule]: {
      isValid: false,
      data: undefined
    },
    [_types.RuleStep.ruleActions]: {
      isValid: false,
      data: undefined
    }
  });
  const [defineStep, setDefineStep] = (0, _react.useState)(stepsData.current[_types.RuleStep.defineRule]);
  const [aboutStep, setAboutStep] = (0, _react.useState)(stepsData.current[_types.RuleStep.aboutRule]);
  const [scheduleStep, setScheduleStep] = (0, _react.useState)(stepsData.current[_types.RuleStep.scheduleRule]);
  const [actionsStep, setActionsStep] = (0, _react.useState)(stepsData.current[_types.RuleStep.ruleActions]);
  const [activeStep, setActiveStep] = (0, _react.useState)(_types.RuleStep.defineRule);
  const invalidSteps = _utils.ruleStepsOrder.filter(step => {
    const stepData = stepsData.current[step];
    return stepData.data != null && !(0, _helpers.stepIsValid)(stepData);
  });
  const {
    mutateAsync: updateRule,
    isLoading
  } = (0, _logic.useUpdateRule)();
  const [dataViewOptions, setDataViewOptions] = (0, _react.useState)({});
  const [isPreviewDisabled, setIsPreviewDisabled] = (0, _react.useState)(false);
  const [isRulePreviewVisible, setIsRulePreviewVisible] = (0, _react.useState)(true);
  const collapseFn = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    const fetchDataViews = async () => {
      const dataViewsRefs = await dataServices.dataViews.getIdsWithTitle();
      const dataViewIdIndexPatternMap = dataViewsRefs.reduce((acc, item) => ({
        ...acc,
        [item.id]: item
      }), {});
      setDataViewOptions(dataViewIdIndexPatternMap);
    };
    fetchDataViews();
  }, [dataServices.dataViews]);
  const actionMessageParams = (0, _react.useMemo)(() => (0, _helpers2.getActionMessageParams)(rule === null || rule === void 0 ? void 0 : rule.type), [rule === null || rule === void 0 ? void 0 : rule.type]);
  const setFormHook = (0, _react.useCallback)((step, hook) => {
    formHooks.current[step] = hook;
    if (step === activeStep) {
      hook();
    }
  }, [activeStep]);
  const setStepData = (0, _react.useCallback)((step, data, isValid) => {
    switch (step) {
      case _types.RuleStep.aboutRule:
        const aboutData = data;
        setAboutStep({
          ...stepsData.current[step],
          data: aboutData,
          isValid
        });
        return;
      case _types.RuleStep.defineRule:
        const defineData = data;
        setDefineStep({
          ...stepsData.current[step],
          data: defineData,
          isValid
        });
        return;
      case _types.RuleStep.ruleActions:
        const actionsData = data;
        setActionsStep({
          ...stepsData.current[step],
          data: actionsData,
          isValid
        });
        return;
      case _types.RuleStep.scheduleRule:
        const scheduleData = data;
        setScheduleStep({
          ...stepsData.current[step],
          data: scheduleData,
          isValid
        });
    }
  }, []);
  const onDataChange = (0, _react.useCallback)(async () => {
    if (activeStep === _types.RuleStep.defineRule) {
      const defineStepData = await formHooks.current[_types.RuleStep.defineRule]();
      if (defineStepData !== null && defineStepData !== void 0 && defineStepData.isValid && defineStepData !== null && defineStepData !== void 0 && defineStepData.data) {
        setDefineStep(defineStepData);
      }
    } else if (activeStep === _types.RuleStep.aboutRule) {
      const aboutStepData = await formHooks.current[_types.RuleStep.aboutRule]();
      if (aboutStepData !== null && aboutStepData !== void 0 && aboutStepData.isValid && aboutStepData !== null && aboutStepData !== void 0 && aboutStepData.data) {
        setAboutStep(aboutStepData);
      }
    } else if (activeStep === _types.RuleStep.scheduleRule) {
      const scheduleStepData = await formHooks.current[_types.RuleStep.scheduleRule]();
      if (scheduleStepData !== null && scheduleStepData !== void 0 && scheduleStepData.isValid && scheduleStepData !== null && scheduleStepData !== void 0 && scheduleStepData.data) {
        setScheduleStep(scheduleStepData);
      }
    }
  }, [activeStep]);
  const [indicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_INDEX_KEY);
  const [threatIndicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_THREAT_INDEX_KEY);
  const defineStepDataWithSavedQuery = (0, _react.useMemo)(() => defineStep.data ? {
    ...defineStep.data,
    queryBar: savedQueryBar !== null && savedQueryBar !== void 0 ? savedQueryBar : defineStep.data.queryBar
  } : defineStep.data, [defineStep.data, savedQueryBar]);
  const tabs = (0, _react.useMemo)(() => [{
    'data-test-subj': 'edit-rule-define-tab',
    id: _types.RuleStep.defineRule,
    name: ruleI18n.DEFINITION,
    disabled: rule === null || rule === void 0 ? void 0 : rule.immutable,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading || isSavedQueryLoading,
      title: ruleI18n.DEFINITION
    }, defineStepDataWithSavedQuery != null && !isSavedQueryLoading && /*#__PURE__*/_react.default.createElement(_step_define_rule.StepDefineRule, {
      isReadOnlyView: false,
      isLoading: isLoading || isSavedQueryLoading,
      isUpdateView: true,
      defaultValues: defineStepDataWithSavedQuery,
      setForm: setFormHook,
      kibanaDataViews: dataViewOptions,
      indicesConfig: indicesConfig,
      threatIndicesConfig: threatIndicesConfig,
      onRuleDataChange: onDataChange,
      onPreviewDisabledStateChange: setIsPreviewDisabled,
      defaultSavedQuery: savedQuery
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }, {
    'data-test-subj': 'edit-rule-about-tab',
    id: _types.RuleStep.aboutRule,
    name: ruleI18n.ABOUT,
    disabled: rule === null || rule === void 0 ? void 0 : rule.immutable,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading,
      title: ruleI18n.ABOUT
    }, aboutStep.data != null && defineStep.data != null && /*#__PURE__*/_react.default.createElement(_step_about_rule.StepAboutRule, {
      isReadOnlyView: false,
      isLoading: isLoading,
      isUpdateView: true,
      defaultValues: aboutStep.data,
      defineRuleData: defineStep.data,
      setForm: setFormHook,
      onRuleDataChange: onDataChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }, {
    'data-test-subj': 'edit-rule-schedule-tab',
    id: _types.RuleStep.scheduleRule,
    name: ruleI18n.SCHEDULE,
    disabled: rule === null || rule === void 0 ? void 0 : rule.immutable,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading,
      title: ruleI18n.SCHEDULE
    }, scheduleStep.data != null && /*#__PURE__*/_react.default.createElement(_step_schedule_rule.StepScheduleRule, {
      isReadOnlyView: false,
      isLoading: isLoading,
      isUpdateView: true,
      defaultValues: scheduleStep.data,
      setForm: setFormHook,
      onRuleDataChange: onDataChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }, {
    'data-test-subj': 'edit-rule-actions-tab',
    id: _types.RuleStep.ruleActions,
    name: ruleI18n.ACTIONS,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading
    }, actionsStep.data != null && /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActions, {
      ruleId: rule === null || rule === void 0 ? void 0 : rule.id,
      isReadOnlyView: false,
      isLoading: isLoading,
      isUpdateView: true,
      defaultValues: actionsStep.data,
      setForm: setFormHook,
      actionMessageParams: actionMessageParams,
      summaryActionMessageParams: actionMessageParams,
      ruleType: rule === null || rule === void 0 ? void 0 : rule.type
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }], [rule === null || rule === void 0 ? void 0 : rule.id, rule === null || rule === void 0 ? void 0 : rule.immutable, rule === null || rule === void 0 ? void 0 : rule.type, loading, defineStep.data, isLoading, isSavedQueryLoading, defineStepDataWithSavedQuery, setFormHook, dataViewOptions, indicesConfig, threatIndicesConfig, onDataChange, aboutStep.data, scheduleStep.data, actionsStep.data, actionMessageParams, savedQuery]);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const onSubmit = (0, _react.useCallback)(async () => {
    const activeStepData = await formHooks.current[activeStep]();
    if ((activeStepData === null || activeStepData === void 0 ? void 0 : activeStepData.data) != null) {
      setStepData(activeStep, activeStepData.data, activeStepData.isValid);
    }
    const define = (0, _helpers.isDefineStep)(activeStepData) ? activeStepData : defineStep;
    const about = (0, _helpers.isAboutStep)(activeStepData) ? activeStepData : aboutStep;
    const schedule = (0, _helpers.isScheduleStep)(activeStepData) ? activeStepData : scheduleStep;
    const actions = (0, _helpers.isActionsStep)(activeStepData) ? activeStepData : actionsStep;
    if ((0, _helpers.stepIsValid)(define) && (0, _helpers.stepIsValid)(about) && (0, _helpers.stepIsValid)(schedule) && (0, _helpers.stepIsValid)(actions)) {
      var _rule$name;
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.SAVE
      });
      await updateRule({
        ...(0, _helpers.formatRule)(define.data, about.data, schedule.data, actions.data, rule === null || rule === void 0 ? void 0 : rule.exceptions_list),
        ...(ruleId ? {
          id: ruleId
        } : {}),
        ...(rule != null ? {
          max_signals: rule.max_signals
        } : {})
      });
      (0, _toasters.displaySuccessToast)(i18n.SUCCESSFULLY_SAVED_RULE((_rule$name = rule === null || rule === void 0 ? void 0 : rule.name) !== null && _rule$name !== void 0 ? _rule$name : ''), dispatchToaster);
      navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types2.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
      });
    }
  }, [aboutStep, actionsStep, activeStep, defineStep, dispatchToaster, navigateToApp, rule, ruleId, scheduleStep, setStepData, updateRule, startTransaction]);
  (0, _react.useEffect)(() => {
    if (rule != null) {
      const {
        aboutRuleData,
        defineRuleData,
        scheduleRuleData,
        ruleActionsData
      } = (0, _helpers2.getStepsData)({
        rule
      });
      setStepData(_types.RuleStep.defineRule, defineRuleData, true);
      setStepData(_types.RuleStep.aboutRule, aboutRuleData, true);
      setStepData(_types.RuleStep.scheduleRule, scheduleRuleData, true);
      setStepData(_types.RuleStep.ruleActions, ruleActionsData, true);
    }
  }, [rule, setStepData]);
  const goToStep = (0, _react.useCallback)(async step => {
    setActiveStep(step);
    await formHooks.current[step]();
  }, []);
  const onTabClick = (0, _react.useCallback)(async tab => {
    const targetStep = tab.id;
    const activeStepData = await formHooks.current[activeStep]();
    if ((activeStepData === null || activeStepData === void 0 ? void 0 : activeStepData.data) != null) {
      setStepData(activeStep, activeStepData.data, activeStepData.isValid);
      goToStep(targetStep);
    }
  }, [activeStep, goToStep, setStepData]);
  const goToDetailsRule = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
    });
  }, [navigateToApp, ruleId]);
  (0, _react.useEffect)(() => {
    if (rule !== null && rule !== void 0 && rule.immutable) {
      setActiveStep(_types.RuleStep.ruleActions);
    } else {
      setActiveStep(_types.RuleStep.defineRule);
    }
  }, [rule]);
  if ((0, _helpers2.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  } else if (!(0, _privileges.hasUserCRUDPermission)(canUserCRUD)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, null, (EuiResizablePanel, EuiResizableButton, {
    togglePanel
  }) => {
    var _rule$name2;
    collapseFn.current = () => togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel('preview', {
      direction: 'left'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      initialSize: 70,
      minSize: '40%',
      mode: "main"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_helpers2.MaxWidthEuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      backOptions: {
        path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : ''),
        text: `${i18n.BACK_TO} ${(_rule$name2 = rule === null || rule === void 0 ? void 0 : rule.name) !== null && _rule$name2 !== void 0 ? _rule$name2 : ''}`,
        pageId: _types2.SecurityPageName.rules,
        dataTestSubj: 'ruleEditBackToRuleDetails'
      },
      isLoading: isLoading,
      title: i18n.PAGE_TITLE
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "preview-container",
      isSelected: isRulePreviewVisible,
      fill: isRulePreviewVisible,
      iconType: "visBarVerticalStacked",
      onClick: () => {
        var _collapseFn$current;
        (_collapseFn$current = collapseFn.current) === null || _collapseFn$current === void 0 ? void 0 : _collapseFn$current.call(collapseFn);
        setIsRulePreviewVisible(isVisible => !isVisible);
      }
    }, ruleI18n.RULE_PREVIEW_TITLE)), invalidSteps.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.SORRY_ERRORS,
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rule.editRule.errorMsgDescription",
      defaultMessage: "You have an invalid input in {countError, plural, one {this tab} other {these tabs}}: {tabHasError}",
      values: {
        countError: invalidSteps.length,
        tabHasError: invalidSteps.map(t => {
          if (t === _types.RuleStep.aboutRule) {
            return ruleI18n.ABOUT;
          } else if (t === _types.RuleStep.defineRule) {
            return ruleI18n.DEFINITION;
          } else if (t === _types.RuleStep.scheduleRule) {
            return ruleI18n.SCHEDULE;
          } else if (t === _types.RuleStep.ruleActions) {
            return ruleI18n.RULE_ACTIONS;
          }
          return t;
        }).join(', ')
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
      initialSelectedTab: tabs[0],
      selectedTab: tabs.find(t => t.id === activeStep),
      onTabClick: onTabClick,
      tabs: tabs
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      justifyContent: "flexEnd",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "cross",
      onClick: goToDetailsRule
    }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "ruleEditSubmitButton",
      fill: true,
      onClick: onSubmit,
      iconType: "save",
      isLoading: isLoading,
      isDisabled: loading
    }, i18n.SAVE_CHANGES)))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, null), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: 'preview',
      mode: "collapsible",
      initialSize: 30,
      minSize: '20%',
      onToggleCollapsed: () => setIsRulePreviewVisible(isVisible => !isVisible)
    }, defineStep.data && aboutStep.data && scheduleStep.data && /*#__PURE__*/_react.default.createElement(_rule_preview.RulePreview, {
      isDisabled: isPreviewDisabled,
      defineRuleData: defineStep.data,
      aboutRuleData: aboutStep.data,
      scheduleRuleData: scheduleStep.data,
      exceptionsList: rule === null || rule === void 0 ? void 0 : rule.exceptions_list
    })));
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types2.SecurityPageName.rules,
    state: {
      ruleName: rule === null || rule === void 0 ? void 0 : rule.name
    }
  }));
};
const EditRulePage = /*#__PURE__*/(0, _react.memo)(EditRulePageComponent);
exports.EditRulePage = EditRulePage;