"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESSFULLY_CREATED_RULES = exports.RULE_PREVIEW_TITLE = exports.PAGE_TITLE = exports.EDIT_RULE = exports.CANCEL_BUTTON_LABEL = exports.BACK_TO_RULES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.pageTitle', {
  defaultMessage: 'Create new rule'
});
exports.PAGE_TITLE = PAGE_TITLE;
const BACK_TO_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.backToRulesButton', {
  defaultMessage: 'Rules'
});
exports.BACK_TO_RULES = BACK_TO_RULES;
const RULE_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.rulePreviewTitle', {
  defaultMessage: 'Rule preview'
});
exports.RULE_PREVIEW_TITLE = RULE_PREVIEW_TITLE;
const CANCEL_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL_BUTTON_LABEL = CANCEL_BUTTON_LABEL;
const EDIT_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.editRuleButton', {
  defaultMessage: 'Edit'
});
exports.EDIT_RULE = EDIT_RULE;
const SUCCESSFULLY_CREATED_RULES = ruleName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.create.successfullyCreatedRuleTitle', {
  values: {
    ruleName
  },
  defaultMessage: '{ruleName} was created'
});
exports.SUCCESSFULLY_CREATED_RULES = SUCCESSFULLY_CREATED_RULES;