"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateRulePage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _utils = require("../../../../../common/detection_engine/utils");
var _logic = require("../../../rule_management/logic");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _privileges = require("../../../../common/utils/privileges");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _user_info = require("../../../../detections/components/user_info");
var _accordion_title = require("../../../../detections/components/rules/accordion_title");
var _step_define_rule = require("../../../../detections/components/rules/step_define_rule");
var _step_about_rule = require("../../../../detections/components/rules/step_about_rule");
var _step_schedule_rule = require("../../../../detections/components/rules/step_schedule_rule");
var _step_rule_actions = require("../../../../detections/components/rules/step_rule_actions");
var RuleI18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _helpers = require("../../../../detections/pages/detection_engine/rules/helpers");
var _types = require("../../../../detections/pages/detection_engine/rules/types");
var _helpers2 = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("../../../../app/types");
var _utils2 = require("../../../../detections/pages/detection_engine/rules/utils");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _header_page = require("../../../../common/components/header_page");
var _rule_preview = require("../../../../detections/components/rules/rule_preview");
var _use_start_ml_jobs = require("../../../rule_management/logic/use_start_ml_jobs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formHookNoop = async () => undefined;
const MyEuiPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  position: relative;
  z-index: ${props => props.zindex}; /* ugly fix to allow searchBar to overflow the EuiPanel */

  > .euiAccordion > .euiAccordion__triggerWrapper {
    .euiAccordion__button {
      cursor: default !important;
      &:hover {
        text-decoration: none !important;
      }
    }

    .euiAccordion__iconWrapper {
      display: none;
    }
  }
  .euiAccordion__childWrapper {
    transform: none; /* To circumvent an issue in Eui causing the fullscreen datagrid to break */
  }
`;
MyEuiPanel.displayName = 'MyEuiPanel';
const isShouldRerenderStep = (step, activeStep) => activeStep !== step ? '0' : '1';
const CreateRulePageComponent = () => {
  var _stepsData$current$Ru;
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const {
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const loading = userInfoLoading || listsConfigLoading;
  const [activeStep, setActiveStep] = (0, _react.useState)(_types.RuleStep.defineRule);
  const getNextStep = step => _utils2.ruleStepsOrder[_utils2.ruleStepsOrder.indexOf(step) + 1];
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const defineRuleRef = (0, _react.useRef)(null);
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const aboutRuleRef = (0, _react.useRef)(null);
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const scheduleRuleRef = (0, _react.useRef)(null);
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const ruleActionsRef = (0, _react.useRef)(null);
  const [indicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_INDEX_KEY);
  const [threatIndicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_THREAT_INDEX_KEY);
  const formHooks = (0, _react.useRef)({
    [_types.RuleStep.defineRule]: formHookNoop,
    [_types.RuleStep.aboutRule]: formHookNoop,
    [_types.RuleStep.scheduleRule]: formHookNoop,
    [_types.RuleStep.ruleActions]: formHookNoop
  });
  const setFormHook = (0, _react.useCallback)((step, hook) => {
    formHooks.current[step] = hook;
  }, []);
  const stepsData = (0, _react.useRef)({
    [_types.RuleStep.defineRule]: {
      isValid: false,
      data: undefined
    },
    [_types.RuleStep.aboutRule]: {
      isValid: false,
      data: undefined
    },
    [_types.RuleStep.scheduleRule]: {
      isValid: false,
      data: undefined
    },
    [_types.RuleStep.ruleActions]: {
      isValid: false,
      data: undefined
    }
  });
  const setStepData = (step, data) => {
    stepsData.current[step] = data;
  };
  const [openSteps, setOpenSteps] = (0, _react.useState)({
    [_types.RuleStep.defineRule]: false,
    [_types.RuleStep.aboutRule]: false,
    [_types.RuleStep.scheduleRule]: false,
    [_types.RuleStep.ruleActions]: false
  });
  const {
    mutateAsync: createRule,
    isLoading
  } = (0, _logic.useCreateRule)();
  const ruleType = (_stepsData$current$Ru = stepsData.current[_types.RuleStep.defineRule].data) === null || _stepsData$current$Ru === void 0 ? void 0 : _stepsData$current$Ru.ruleType;
  const actionMessageParams = (0, _react.useMemo)(() => (0, _helpers.getActionMessageParams)(ruleType), [ruleType]);
  const [dataViewOptions, setDataViewOptions] = (0, _react.useState)({});
  const [isPreviewDisabled, setIsPreviewDisabled] = (0, _react.useState)(false);
  const [isRulePreviewVisible, setIsRulePreviewVisible] = (0, _react.useState)(true);
  const collapseFn = (0, _react.useRef)();
  const [defineRuleData, setDefineRuleData] = (0, _react.useState)({
    ..._utils2.stepDefineDefaultValue,
    index: indicesConfig,
    threatIndex: threatIndicesConfig
  });
  const [aboutRuleData, setAboutRuleData] = (0, _react.useState)(_utils2.stepAboutDefaultValue);
  const [scheduleRuleData, setScheduleRuleData] = (0, _react.useState)((0, _utils2.getStepScheduleDefaultValue)(defineRuleData.ruleType));
  (0, _react.useEffect)(() => {
    const isThreatMatchRuleValue = (0, _utils.isThreatMatchRule)(defineRuleData.ruleType);
    if (isThreatMatchRuleValue) {
      setAboutRuleData({
        ..._utils2.stepAboutDefaultValue,
        threatIndicatorPath: _constants.DEFAULT_INDICATOR_SOURCE_PATH
      });
    } else {
      setAboutRuleData(_utils2.stepAboutDefaultValue);
    }
    setScheduleRuleData((0, _utils2.getStepScheduleDefaultValue)(defineRuleData.ruleType));
  }, [defineRuleData.ruleType]);
  const updateCurrentDataState = (0, _react.useCallback)(data => {
    if (activeStep === _types.RuleStep.defineRule) {
      setDefineRuleData(data);
    } else if (activeStep === _types.RuleStep.aboutRule) {
      setAboutRuleData(data);
    } else if (activeStep === _types.RuleStep.scheduleRule) {
      setScheduleRuleData(data);
    }
  }, [activeStep]);
  const {
    starting: isStartingJobs,
    startMlJobs
  } = (0, _use_start_ml_jobs.useStartMlJobs)();
  (0, _react.useEffect)(() => {
    const fetchDV = async () => {
      const dataViewsRefs = await dataViews.getIdsWithTitle();
      const dataViewIdIndexPatternMap = dataViewsRefs.reduce((acc, item) => ({
        ...acc,
        [item.id]: item
      }), {});
      setDataViewOptions(dataViewIdIndexPatternMap);
    };
    fetchDV();
  }, [dataViews]);
  const handleAccordionToggle = (0, _react.useCallback)((step, isOpen) => setOpenSteps(_openSteps => ({
    ..._openSteps,
    [step]: isOpen
  })), []);
  const goToStep = (0, _react.useCallback)(step => {
    if (_utils2.ruleStepsOrder.indexOf(step) > _utils2.ruleStepsOrder.indexOf(activeStep) && !openSteps[step]) {
      toggleStepAccordion(step);
    }
    setActiveStep(step);
  }, [activeStep, openSteps]);
  const toggleStepAccordion = step => {
    if (step === _types.RuleStep.defineRule) {
      var _defineRuleRef$curren;
      (_defineRuleRef$curren = defineRuleRef.current) === null || _defineRuleRef$curren === void 0 ? void 0 : _defineRuleRef$curren.onToggle();
    } else if (step === _types.RuleStep.aboutRule) {
      var _aboutRuleRef$current;
      (_aboutRuleRef$current = aboutRuleRef.current) === null || _aboutRuleRef$current === void 0 ? void 0 : _aboutRuleRef$current.onToggle();
    } else if (step === _types.RuleStep.scheduleRule) {
      var _scheduleRuleRef$curr;
      (_scheduleRuleRef$curr = scheduleRuleRef.current) === null || _scheduleRuleRef$curr === void 0 ? void 0 : _scheduleRuleRef$curr.onToggle();
    } else if (step === _types.RuleStep.ruleActions) {
      var _ruleActionsRef$curre;
      (_ruleActionsRef$curre = ruleActionsRef.current) === null || _ruleActionsRef$curre === void 0 ? void 0 : _ruleActionsRef$curre.onToggle();
    }
  };
  const editStep = (0, _react.useCallback)(async step => {
    const activeStepData = await formHooks.current[activeStep]();
    if (activeStepData !== null && activeStepData !== void 0 && activeStepData.isValid) {
      setStepData(activeStep, activeStepData);
      goToStep(step);
    }
  }, [activeStep, goToStep]);
  const submitStep = (0, _react.useCallback)(async step => {
    const stepData = await formHooks.current[step]();
    if (stepData !== null && stepData !== void 0 && stepData.isValid && stepData.data) {
      updateCurrentDataState(stepData.data);
      setStepData(step, stepData);
      const nextStep = getNextStep(step);
      if (nextStep != null) {
        goToStep(nextStep);
      } else {
        const defineStep = stepsData.current[_types.RuleStep.defineRule];
        const aboutStep = stepsData.current[_types.RuleStep.aboutRule];
        const scheduleStep = stepsData.current[_types.RuleStep.scheduleRule];
        const actionsStep = stepsData.current[_types.RuleStep.ruleActions];
        if ((0, _helpers2.stepIsValid)(defineStep) && (0, _helpers2.stepIsValid)(aboutStep) && (0, _helpers2.stepIsValid)(scheduleStep) && (0, _helpers2.stepIsValid)(actionsStep)) {
          const startMlJobsIfNeeded = async () => {
            if (!(0, _utils.isMlRule)(defineStep.data.ruleType) || !actionsStep.data.enabled) {
              return;
            }
            await startMlJobs(defineStep.data.machineLearningJobId);
          };
          const [, createdRule] = await Promise.all([startMlJobsIfNeeded(), createRule((0, _helpers2.formatRule)(defineStep.data, aboutStep.data, scheduleStep.data, actionsStep.data))]);
          addSuccess(i18n.SUCCESSFULLY_CREATED_RULES(createdRule.name));
          navigateToApp(_constants.APP_UI_ID, {
            deepLinkId: _types2.SecurityPageName.rules,
            path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(createdRule.id)
          });
        }
      }
    }
  }, [updateCurrentDataState, goToStep, createRule, navigateToApp, startMlJobs, addSuccess]);
  const getAccordionType = (0, _react.useCallback)(step => {
    if (step === activeStep) {
      return 'active';
    } else if (stepsData.current[step].isValid) {
      return 'valid';
    }
    return 'passive';
  }, [activeStep]);
  const defineRuleButton = /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "1",
    title: RuleI18n.DEFINE_RULE,
    type: getAccordionType(_types.RuleStep.defineRule)
  });
  const aboutRuleButton = /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "2",
    title: RuleI18n.ABOUT_RULE,
    type: getAccordionType(_types.RuleStep.aboutRule)
  });
  const scheduleRuleButton = /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "3",
    title: RuleI18n.SCHEDULE_RULE,
    type: getAccordionType(_types.RuleStep.scheduleRule)
  });
  const ruleActionsButton = /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "4",
    title: RuleI18n.RULE_ACTIONS,
    type: getAccordionType(_types.RuleStep.ruleActions)
  });
  if ((0, _helpers.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  } else if (!(0, _privileges.hasUserCRUDPermission)(canUserCRUD)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRulesUrl)()
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, null, (EuiResizablePanel, EuiResizableButton, {
    togglePanel
  }) => {
    collapseFn.current = () => togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel('preview', {
      direction: 'left'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      initialSize: 70,
      minSize: '40%',
      mode: "main"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_helpers.MaxWidthEuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      backOptions: {
        path: (0, _redirect_to_detection_engine.getRulesUrl)(),
        text: i18n.BACK_TO_RULES,
        pageId: _types2.SecurityPageName.rules
      },
      isLoading: isLoading || loading,
      title: i18n.PAGE_TITLE
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "preview-container",
      isSelected: isRulePreviewVisible,
      fill: isRulePreviewVisible,
      iconType: "visBarVerticalStacked",
      onClick: () => {
        var _collapseFn$current;
        (_collapseFn$current = collapseFn.current) === null || _collapseFn$current === void 0 ? void 0 : _collapseFn$current.call(collapseFn);
        setIsRulePreviewVisible(isVisible => !isVisible);
      }
    }, i18n.RULE_PREVIEW_TITLE)), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      zindex: 4,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      initialIsOpen: true,
      id: _types.RuleStep.defineRule,
      buttonContent: defineRuleButton,
      paddingSize: "xs",
      ref: defineRuleRef,
      onToggle: handleAccordionToggle.bind(null, _types.RuleStep.defineRule),
      extraAction: stepsData.current[_types.RuleStep.defineRule].isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "edit-define-rule",
        iconType: "pencil",
        size: "xs",
        onClick: () => editStep(_types.RuleStep.defineRule)
      }, i18n.EDIT_RULE)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement(_step_define_rule.StepDefineRule, {
      addPadding: true,
      defaultValues: defineRuleData,
      isReadOnlyView: activeStep !== _types.RuleStep.defineRule,
      isLoading: isLoading || loading,
      setForm: setFormHook,
      onSubmit: () => submitStep(_types.RuleStep.defineRule),
      kibanaDataViews: dataViewOptions,
      descriptionColumns: "singleSplit"
      // We need a key to make this component remount when edit/view mode is toggled
      // https://github.com/elastic/kibana/pull/132834#discussion_r881705566
      ,
      key: isShouldRerenderStep(_types.RuleStep.defineRule, activeStep),
      indicesConfig: indicesConfig,
      threatIndicesConfig: threatIndicesConfig,
      onRuleDataChange: updateCurrentDataState,
      onPreviewDisabledStateChange: setIsPreviewDisabled
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      hasBorder: true,
      zindex: 3
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      initialIsOpen: false,
      id: _types.RuleStep.aboutRule,
      buttonContent: aboutRuleButton,
      paddingSize: "xs",
      ref: aboutRuleRef,
      onToggle: handleAccordionToggle.bind(null, _types.RuleStep.aboutRule),
      extraAction: stepsData.current[_types.RuleStep.aboutRule].isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "edit-about-rule",
        iconType: "pencil",
        size: "xs",
        onClick: () => editStep(_types.RuleStep.aboutRule)
      }, i18n.EDIT_RULE)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement(_step_about_rule.StepAboutRule, {
      addPadding: true,
      defaultValues: aboutRuleData,
      defineRuleData: defineRuleData,
      descriptionColumns: "singleSplit",
      isReadOnlyView: activeStep !== _types.RuleStep.aboutRule,
      isLoading: isLoading || loading,
      setForm: setFormHook,
      onSubmit: () => submitStep(_types.RuleStep.aboutRule)
      // We need a key to make this component remount when edit/view mode is toggled
      // https://github.com/elastic/kibana/pull/132834#discussion_r881705566
      ,
      key: isShouldRerenderStep(_types.RuleStep.aboutRule, activeStep),
      onRuleDataChange: updateCurrentDataState
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      hasBorder: true,
      zindex: 2
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      initialIsOpen: false,
      id: _types.RuleStep.scheduleRule,
      buttonContent: scheduleRuleButton,
      paddingSize: "xs",
      ref: scheduleRuleRef,
      onToggle: handleAccordionToggle.bind(null, _types.RuleStep.scheduleRule),
      extraAction: stepsData.current[_types.RuleStep.scheduleRule].isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "pencil",
        size: "xs",
        onClick: () => editStep(_types.RuleStep.scheduleRule)
      }, i18n.EDIT_RULE)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement(_step_schedule_rule.StepScheduleRule, {
      addPadding: true,
      defaultValues: scheduleRuleData,
      descriptionColumns: "singleSplit",
      isReadOnlyView: activeStep !== _types.RuleStep.scheduleRule,
      isLoading: isLoading || loading,
      setForm: setFormHook,
      onSubmit: () => submitStep(_types.RuleStep.scheduleRule)
      // We need a key to make this component remount when edit/view mode is toggled
      // https://github.com/elastic/kibana/pull/132834#discussion_r881705566
      ,
      key: isShouldRerenderStep(_types.RuleStep.scheduleRule, activeStep),
      onRuleDataChange: updateCurrentDataState
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      hasBorder: true,
      zindex: 1
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      initialIsOpen: false,
      id: _types.RuleStep.ruleActions,
      buttonContent: ruleActionsButton,
      paddingSize: "xs",
      ref: ruleActionsRef,
      onToggle: handleAccordionToggle.bind(null, _types.RuleStep.ruleActions),
      extraAction: stepsData.current[_types.RuleStep.ruleActions].isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "pencil",
        size: "xs",
        onClick: () => editStep(_types.RuleStep.ruleActions)
      }, i18n.EDIT_RULE)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActions, {
      addPadding: true,
      defaultValues: stepsData.current[_types.RuleStep.ruleActions].data,
      isReadOnlyView: activeStep !== _types.RuleStep.ruleActions,
      isLoading: isLoading || loading || isStartingJobs,
      setForm: setFormHook,
      onSubmit: () => submitStep(_types.RuleStep.ruleActions),
      actionMessageParams: actionMessageParams,
      summaryActionMessageParams: actionMessageParams
      // We need a key to make this component remount when edit/view mode is toggled
      // https://github.com/elastic/kibana/pull/132834#discussion_r881705566
      ,
      key: isShouldRerenderStep(_types.RuleStep.ruleActions, activeStep),
      ruleType: ruleType
    })))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, null), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: 'preview',
      mode: "collapsible",
      initialSize: 30,
      minSize: '20%',
      onToggleCollapsed: () => setIsRulePreviewVisible(isVisible => !isVisible)
    }, /*#__PURE__*/_react.default.createElement(_rule_preview.RulePreview, {
      isDisabled: isPreviewDisabled && activeStep === _types.RuleStep.defineRule,
      defineRuleData: defineRuleData,
      aboutRuleData: aboutRuleData,
      scheduleRuleData: scheduleRuleData
    })));
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types2.SecurityPageName.rulesCreate
  }));
};
const CreateRulePage = /*#__PURE__*/_react.default.memo(CreateRulePageComponent);
exports.CreateRulePage = CreateRulePage;