"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepIsValid = exports.isScheduleStep = exports.isDefineStep = exports.isActionsStep = exports.isAboutStep = exports.getTimeTypeValue = exports.getStepDataDataSource = exports.formatScheduleStepData = exports.formatRule = exports.formatPreviewRule = exports.formatDefineStepData = exports.formatActionsStepData = exports.formatAboutStepData = exports.filterRuleFieldsForType = exports.filterEmptyThreats = void 0;
var _fp = require("lodash/fp");
var _moment = _interopRequireDefault(require("moment"));
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _omit = _interopRequireDefault(require("lodash/omit"));
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _utility_types = require("../../../../../common/utility_types");
var _transform_actions = require("../../../../../common/detection_engine/transform_actions");
var _types = require("../../../../detections/pages/detection_engine/rules/types");
var _rule_schema = require("../../../../../common/detection_engine/rule_schema");
var _step_rule_actions = require("../../../../detections/components/rules/step_rule_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

const getTimeTypeValue = time => {
  const timeObj = {
    unit: 'ms',
    value: 0
  };
  const filterTimeVal = time.match(/\d+/g);
  const filterTimeType = time.match(/[a-zA-Z]+/g);
  if (!(0, _fp.isEmpty)(filterTimeVal) && filterTimeVal != null && !isNaN(Number(filterTimeVal[0]))) {
    timeObj.value = Number(filterTimeVal[0]);
  }
  if (!(0, _fp.isEmpty)(filterTimeType) && filterTimeType != null && ['s', 'm', 'h'].includes(filterTimeType[0])) {
    timeObj.unit = filterTimeType[0];
  }
  return timeObj;
};
exports.getTimeTypeValue = getTimeTypeValue;
const stepIsValid = formData => !!(formData !== null && formData !== void 0 && formData.isValid) && !!formData.data;
exports.stepIsValid = stepIsValid;
const isDefineStep = input => (0, _fp.has)('data.ruleType', input);
exports.isDefineStep = isDefineStep;
const isAboutStep = input => (0, _fp.has)('data.name', input);
exports.isAboutStep = isAboutStep;
const isScheduleStep = input => (0, _fp.has)('data.interval', input);
exports.isScheduleStep = isScheduleStep;
const isActionsStep = input => (0, _fp.has)('data.actions', input);
exports.isActionsStep = isActionsStep;
const isMlFields = fields => (0, _fp.has)('anomalyThreshold', fields);
const isThresholdFields = fields => (0, _fp.has)('threshold', fields);
const isThreatMatchFields = fields => (0, _fp.has)('threatIndex', fields);
const isNewTermsFields = fields => (0, _fp.has)('newTermsFields', fields);
const isEqlFields = fields => (0, _fp.has)('eqlOptions', fields);
const filterRuleFieldsForType = (fields, type) => {
  switch (type) {
    case 'machine_learning':
      const {
        index,
        queryBar,
        threshold,
        threatIndex,
        threatQueryBar,
        threatMapping,
        eqlOptions,
        newTermsFields,
        historyWindowSize,
        ...mlRuleFields
      } = fields;
      return mlRuleFields;
    case 'threshold':
      const {
        anomalyThreshold,
        machineLearningJobId,
        threatIndex: _removedThreatIndex,
        threatQueryBar: _removedThreatQueryBar,
        threatMapping: _removedThreatMapping,
        eqlOptions: _eqlOptions,
        newTermsFields: removedNewTermsFields,
        historyWindowSize: removedHistoryWindowSize,
        ...thresholdRuleFields
      } = fields;
      return thresholdRuleFields;
    case 'threat_match':
      const {
        anomalyThreshold: _removedAnomalyThreshold,
        machineLearningJobId: _removedMachineLearningJobId,
        threshold: _removedThreshold,
        eqlOptions: __eqlOptions,
        newTermsFields: _removedNewTermsFields,
        historyWindowSize: _removedHistoryWindowSize,
        ...threatMatchRuleFields
      } = fields;
      return threatMatchRuleFields;
    case 'query':
    case 'saved_query':
      const {
        anomalyThreshold: _a,
        machineLearningJobId: _m,
        threshold: _t,
        threatIndex: __removedThreatIndex,
        threatQueryBar: __removedThreatQueryBar,
        threatMapping: __removedThreatMapping,
        eqlOptions: ___eqlOptions,
        newTermsFields: __removedNewTermsFields,
        historyWindowSize: __removedHistoryWindowSize,
        ...queryRuleFields
      } = fields;
      return queryRuleFields;
    case 'eql':
      const {
        anomalyThreshold: __a,
        machineLearningJobId: __m,
        threshold: __t,
        threatIndex: ___removedThreatIndex,
        threatQueryBar: ___removedThreatQueryBar,
        threatMapping: ___removedThreatMapping,
        newTermsFields: ___removedNewTermsFields,
        historyWindowSize: ___removedHistoryWindowSize,
        ...eqlRuleFields
      } = fields;
      return eqlRuleFields;
    case 'new_terms':
      const {
        anomalyThreshold: ___a,
        machineLearningJobId: ___m,
        threshold: ___t,
        threatIndex: ____removedThreatIndex,
        threatQueryBar: ____removedThreatQueryBar,
        threatMapping: ____removedThreatMapping,
        eqlOptions: ____eqlOptions,
        ...newTermsRuleFields
      } = fields;
      return newTermsRuleFields;
  }
  (0, _utility_types.assertUnreachable)(type);
};
exports.filterRuleFieldsForType = filterRuleFieldsForType;
function trimThreatsWithNoName(filterable) {
  return filterable.filter(item => item.name !== 'none');
}

/**
 * Filter out unfilled/empty threat, technique, and subtechnique fields based on if their name is `none`
 */
const filterEmptyThreats = threats => {
  return threats.filter(singleThreat => singleThreat.tactic.name !== 'none').map(threat => {
    var _threat$technique;
    return {
      ...threat,
      technique: trimThreatsWithNoName((_threat$technique = threat.technique) !== null && _threat$technique !== void 0 ? _threat$technique : []).map(technique => {
        return {
          ...technique,
          subtechnique: technique.subtechnique != null ? trimThreatsWithNoName(technique.subtechnique) : []
        };
      })
    };
  });
};

/**
 * remove unused data source.
 * Ex: rule is using a data view so we should not
 * write an index property on the rule form.
 * @param defineStepData
 * @returns DefineStepRule
 */
exports.filterEmptyThreats = filterEmptyThreats;
const getStepDataDataSource = defineStepData => {
  const copiedStepData = {
    ...defineStepData
  };
  if (defineStepData.dataSourceType === _types.DataSourceType.DataView) {
    return (0, _omit.default)(copiedStepData, ['index', 'dataSourceType']);
  } else if (defineStepData.dataSourceType === _types.DataSourceType.IndexPatterns) {
    return (0, _omit.default)(copiedStepData, ['dataViewId', 'dataSourceType']);
  }
  return copiedStepData;
};
exports.getStepDataDataSource = getStepDataDataSource;
const formatDefineStepData = defineStepData => {
  var _ruleFields$queryBar, _ruleFields$queryBar2, _ruleFields$queryBar3, _ruleFields$queryBar4, _ruleFields$queryBar5, _ruleFields$queryBar$, _ruleFields$queryBar6, _ruleFields$threshold, _ruleFields$threshold2, _parseInt, _ruleFields$threshold3, _ruleFields$threshold4, _ruleFields$threshold5, _ruleFields$queryBar7, _ruleFields$queryBar8, _ruleFields$queryBar9, _ruleFields$queryBar10, _ruleFields$queryBar11, _ruleFields$queryBar$2, _ruleFields$queryBar12, _ruleFields$threatQue, _ruleFields$threatQue2, _ruleFields$threatQue3, _ruleFields$threatQue4, _ruleFields$threatQue5, _ruleFields$queryBar13, _ruleFields$queryBar14, _ruleFields$queryBar15, _ruleFields$queryBar16, _ruleFields$queryBar17, _ruleFields$queryBar$3, _ruleFields$queryBar18, _ruleFields$eqlOption, _ruleFields$eqlOption2, _ruleFields$eqlOption3, _ruleFields$queryBar19, _ruleFields$queryBar20, _ruleFields$queryBar21, _ruleFields$queryBar22, _ruleFields$queryBar23, _ruleFields$queryBar24, _ruleFields$queryBar25, _ruleFields$queryBar26, _ruleFields$queryBar27, _ruleFields$queryBar28, _ruleFields$queryBar29;
  const stepData = getStepDataDataSource(defineStepData);
  const ruleFields = filterRuleFieldsForType(stepData, stepData.ruleType);
  const {
    ruleType,
    timeline
  } = ruleFields;
  const baseFields = {
    type: ruleType,
    ...(timeline.id != null && timeline.title != null && {
      timeline_id: timeline.id,
      timeline_title: timeline.title
    })
  };
  const typeFields = isMlFields(ruleFields) ? {
    anomaly_threshold: ruleFields.anomalyThreshold,
    machine_learning_job_id: ruleFields.machineLearningJobId
  } : isThresholdFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar = ruleFields.queryBar) === null || _ruleFields$queryBar === void 0 ? void 0 : _ruleFields$queryBar.filters,
    language: (_ruleFields$queryBar2 = ruleFields.queryBar) === null || _ruleFields$queryBar2 === void 0 ? void 0 : (_ruleFields$queryBar3 = _ruleFields$queryBar2.query) === null || _ruleFields$queryBar3 === void 0 ? void 0 : _ruleFields$queryBar3.language,
    query: (_ruleFields$queryBar4 = ruleFields.queryBar) === null || _ruleFields$queryBar4 === void 0 ? void 0 : (_ruleFields$queryBar5 = _ruleFields$queryBar4.query) === null || _ruleFields$queryBar5 === void 0 ? void 0 : _ruleFields$queryBar5.query,
    saved_id: (_ruleFields$queryBar$ = (_ruleFields$queryBar6 = ruleFields.queryBar) === null || _ruleFields$queryBar6 === void 0 ? void 0 : _ruleFields$queryBar6.saved_id) !== null && _ruleFields$queryBar$ !== void 0 ? _ruleFields$queryBar$ : undefined,
    ...(ruleType === 'threshold' && {
      threshold: {
        field: (_ruleFields$threshold = (_ruleFields$threshold2 = ruleFields.threshold) === null || _ruleFields$threshold2 === void 0 ? void 0 : _ruleFields$threshold2.field) !== null && _ruleFields$threshold !== void 0 ? _ruleFields$threshold : [],
        value: (_parseInt = parseInt((_ruleFields$threshold3 = ruleFields.threshold) === null || _ruleFields$threshold3 === void 0 ? void 0 : _ruleFields$threshold3.value, 10)) !== null && _parseInt !== void 0 ? _parseInt : 0,
        cardinality: !(0, _fp.isEmpty)((_ruleFields$threshold4 = ruleFields.threshold.cardinality) === null || _ruleFields$threshold4 === void 0 ? void 0 : _ruleFields$threshold4.field) && ((_ruleFields$threshold5 = ruleFields.threshold.cardinality) === null || _ruleFields$threshold5 === void 0 ? void 0 : _ruleFields$threshold5.value) != null ? [{
          field: ruleFields.threshold.cardinality.field[0],
          value: parseInt(ruleFields.threshold.cardinality.value, 10)
        }] : []
      }
    })
  } : isThreatMatchFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar7 = ruleFields.queryBar) === null || _ruleFields$queryBar7 === void 0 ? void 0 : _ruleFields$queryBar7.filters,
    language: (_ruleFields$queryBar8 = ruleFields.queryBar) === null || _ruleFields$queryBar8 === void 0 ? void 0 : (_ruleFields$queryBar9 = _ruleFields$queryBar8.query) === null || _ruleFields$queryBar9 === void 0 ? void 0 : _ruleFields$queryBar9.language,
    query: (_ruleFields$queryBar10 = ruleFields.queryBar) === null || _ruleFields$queryBar10 === void 0 ? void 0 : (_ruleFields$queryBar11 = _ruleFields$queryBar10.query) === null || _ruleFields$queryBar11 === void 0 ? void 0 : _ruleFields$queryBar11.query,
    saved_id: (_ruleFields$queryBar$2 = (_ruleFields$queryBar12 = ruleFields.queryBar) === null || _ruleFields$queryBar12 === void 0 ? void 0 : _ruleFields$queryBar12.saved_id) !== null && _ruleFields$queryBar$2 !== void 0 ? _ruleFields$queryBar$2 : undefined,
    threat_index: ruleFields.threatIndex,
    threat_query: (_ruleFields$threatQue = ruleFields.threatQueryBar) === null || _ruleFields$threatQue === void 0 ? void 0 : (_ruleFields$threatQue2 = _ruleFields$threatQue.query) === null || _ruleFields$threatQue2 === void 0 ? void 0 : _ruleFields$threatQue2.query,
    threat_filters: (_ruleFields$threatQue3 = ruleFields.threatQueryBar) === null || _ruleFields$threatQue3 === void 0 ? void 0 : _ruleFields$threatQue3.filters,
    threat_mapping: ruleFields.threatMapping,
    threat_language: (_ruleFields$threatQue4 = ruleFields.threatQueryBar) === null || _ruleFields$threatQue4 === void 0 ? void 0 : (_ruleFields$threatQue5 = _ruleFields$threatQue4.query) === null || _ruleFields$threatQue5 === void 0 ? void 0 : _ruleFields$threatQue5.language
  } : isEqlFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar13 = ruleFields.queryBar) === null || _ruleFields$queryBar13 === void 0 ? void 0 : _ruleFields$queryBar13.filters,
    language: (_ruleFields$queryBar14 = ruleFields.queryBar) === null || _ruleFields$queryBar14 === void 0 ? void 0 : (_ruleFields$queryBar15 = _ruleFields$queryBar14.query) === null || _ruleFields$queryBar15 === void 0 ? void 0 : _ruleFields$queryBar15.language,
    query: (_ruleFields$queryBar16 = ruleFields.queryBar) === null || _ruleFields$queryBar16 === void 0 ? void 0 : (_ruleFields$queryBar17 = _ruleFields$queryBar16.query) === null || _ruleFields$queryBar17 === void 0 ? void 0 : _ruleFields$queryBar17.query,
    saved_id: (_ruleFields$queryBar$3 = (_ruleFields$queryBar18 = ruleFields.queryBar) === null || _ruleFields$queryBar18 === void 0 ? void 0 : _ruleFields$queryBar18.saved_id) !== null && _ruleFields$queryBar$3 !== void 0 ? _ruleFields$queryBar$3 : undefined,
    timestamp_field: (_ruleFields$eqlOption = ruleFields.eqlOptions) === null || _ruleFields$eqlOption === void 0 ? void 0 : _ruleFields$eqlOption.timestampField,
    event_category_override: (_ruleFields$eqlOption2 = ruleFields.eqlOptions) === null || _ruleFields$eqlOption2 === void 0 ? void 0 : _ruleFields$eqlOption2.eventCategoryField,
    tiebreaker_field: (_ruleFields$eqlOption3 = ruleFields.eqlOptions) === null || _ruleFields$eqlOption3 === void 0 ? void 0 : _ruleFields$eqlOption3.tiebreakerField
  } : isNewTermsFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar19 = ruleFields.queryBar) === null || _ruleFields$queryBar19 === void 0 ? void 0 : _ruleFields$queryBar19.filters,
    language: (_ruleFields$queryBar20 = ruleFields.queryBar) === null || _ruleFields$queryBar20 === void 0 ? void 0 : (_ruleFields$queryBar21 = _ruleFields$queryBar20.query) === null || _ruleFields$queryBar21 === void 0 ? void 0 : _ruleFields$queryBar21.language,
    query: (_ruleFields$queryBar22 = ruleFields.queryBar) === null || _ruleFields$queryBar22 === void 0 ? void 0 : (_ruleFields$queryBar23 = _ruleFields$queryBar22.query) === null || _ruleFields$queryBar23 === void 0 ? void 0 : _ruleFields$queryBar23.query,
    new_terms_fields: ruleFields.newTermsFields,
    history_window_start: `now-${ruleFields.historyWindowSize}`
  } : {
    ...(ruleFields.groupByFields.length > 0 ? {
      alert_suppression: {
        group_by: ruleFields.groupByFields,
        duration: ruleFields.groupByRadioSelection === _types.GroupByOptions.PerTimePeriod ? ruleFields.groupByDuration : undefined,
        missing_fields_strategy: ruleFields.suppressionMissingFields || _rule_schema.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY
      }
    } : {}),
    index: ruleFields.index,
    filters: (_ruleFields$queryBar24 = ruleFields.queryBar) === null || _ruleFields$queryBar24 === void 0 ? void 0 : _ruleFields$queryBar24.filters,
    language: (_ruleFields$queryBar25 = ruleFields.queryBar) === null || _ruleFields$queryBar25 === void 0 ? void 0 : (_ruleFields$queryBar26 = _ruleFields$queryBar25.query) === null || _ruleFields$queryBar26 === void 0 ? void 0 : _ruleFields$queryBar26.language,
    query: (_ruleFields$queryBar27 = ruleFields.queryBar) === null || _ruleFields$queryBar27 === void 0 ? void 0 : (_ruleFields$queryBar28 = _ruleFields$queryBar27.query) === null || _ruleFields$queryBar28 === void 0 ? void 0 : _ruleFields$queryBar28.query,
    saved_id: undefined,
    type: 'query',
    // rule only be updated as saved_query type if it has saved_id and shouldLoadQueryDynamically checkbox checked
    ...(['query', 'saved_query'].includes(ruleType) && ((_ruleFields$queryBar29 = ruleFields.queryBar) === null || _ruleFields$queryBar29 === void 0 ? void 0 : _ruleFields$queryBar29.saved_id) && ruleFields.shouldLoadQueryDynamically && {
      type: 'saved_query',
      query: undefined,
      filters: undefined,
      saved_id: ruleFields.queryBar.saved_id
    })
  };
  return {
    ...baseFields,
    ...typeFields,
    data_view_id: ruleFields.dataViewId
  };
};
exports.formatDefineStepData = formatDefineStepData;
const formatScheduleStepData = scheduleData => {
  const {
    ...formatScheduleData
  } = scheduleData;
  if (!(0, _fp.isEmpty)(formatScheduleData.interval) && !(0, _fp.isEmpty)(formatScheduleData.from)) {
    const {
      unit: intervalUnit,
      value: intervalValue
    } = getTimeTypeValue(formatScheduleData.interval);
    const {
      unit: fromUnit,
      value: fromValue
    } = getTimeTypeValue(formatScheduleData.from);
    const duration = _moment.default.duration(intervalValue, intervalUnit);
    duration.add(fromValue, fromUnit);
    formatScheduleData.from = `now-${duration.asSeconds()}s`;
    formatScheduleData.to = 'now';
  }
  return {
    ...formatScheduleData,
    meta: {
      from: scheduleData.from
    }
  };
};
exports.formatScheduleStepData = formatScheduleStepData;
const formatAboutStepData = (aboutStepData, exceptionsList) => {
  const {
    author,
    falsePositives,
    references,
    riskScore,
    severity,
    threat,
    isAssociatedToEndpointList,
    isBuildingBlock,
    note,
    ruleNameOverride,
    threatIndicatorPath,
    timestampOverride,
    timestampOverrideFallbackDisabled,
    ...rest
  } = aboutStepData;
  const detectionExceptionLists = exceptionsList != null ? exceptionsList.filter(list => list.type !== 'endpoint') : [];
  const resp = {
    author: author.filter(item => !(0, _fp.isEmpty)(item)),
    ...(isBuildingBlock ? {
      building_block_type: 'default'
    } : {}),
    ...(isAssociatedToEndpointList ? {
      exceptions_list: [{
        id: _securitysolutionListConstants.ENDPOINT_LIST_ID,
        list_id: _securitysolutionListConstants.ENDPOINT_LIST_ID,
        namespace_type: 'agnostic',
        type: 'endpoint'
      }, ...detectionExceptionLists]
    } : exceptionsList != null ? {
      exceptions_list: [...detectionExceptionLists]
    } : {}),
    false_positives: falsePositives.filter(item => !(0, _fp.isEmpty)(item)),
    references: references.filter(item => !(0, _fp.isEmpty)(item)),
    risk_score: riskScore.value,
    risk_score_mapping: riskScore.isMappingChecked ? riskScore.mapping.filter(m => m.field != null && m.field !== '') : [],
    rule_name_override: ruleNameOverride !== '' ? ruleNameOverride : undefined,
    severity: severity.value,
    severity_mapping: severity.isMappingChecked ? severity.mapping.filter(m => m.field != null && m.field !== '' && m.value != null) : [],
    threat: filterEmptyThreats(threat).map(singleThreat => ({
      ...singleThreat,
      framework: 'MITRE ATT&CK'
    })),
    threat_indicator_path: threatIndicatorPath,
    timestamp_override: timestampOverride !== '' ? timestampOverride : undefined,
    timestamp_override_fallback_disabled: timestampOverrideFallbackDisabled,
    ...(!(0, _fp.isEmpty)(note) ? {
      note
    } : {}),
    ...rest
  };
  return resp;
};
exports.formatAboutStepData = formatAboutStepData;
const formatActionsStepData = actionsStepData => {
  const {
    actions = [],
    responseActions,
    enabled,
    kibanaSiemAppUrl
  } = actionsStepData;
  return {
    actions: actions.map(_transform_actions.transformAlertToRuleAction),
    response_actions: responseActions === null || responseActions === void 0 ? void 0 : responseActions.map(_transform_actions.transformAlertToRuleResponseAction),
    enabled,
    meta: {
      kibana_siem_app_url: kibanaSiemAppUrl
    }
  };
};

// Used to format form data in rule edit and
// create flows so "T" here would likely
// either be RuleCreateProps or Rule
exports.formatActionsStepData = formatActionsStepData;
const formatRule = (defineStepData, aboutStepData, scheduleData, actionsData, exceptionsList) => _deepmerge.default.all([formatDefineStepData(defineStepData), formatAboutStepData(aboutStepData, exceptionsList), formatScheduleStepData(scheduleData), formatActionsStepData(actionsData)]);
exports.formatRule = formatRule;
const formatPreviewRule = ({
  defineRuleData,
  aboutRuleData,
  scheduleRuleData,
  exceptionsList
}) => {
  const aboutStepData = {
    ...aboutRuleData,
    name: 'Preview Rule',
    description: 'Preview Rule'
  };
  return {
    ...formatRule(defineRuleData, aboutStepData, scheduleRuleData, _step_rule_actions.stepActionsDefaultValue, exceptionsList)
  };
};
exports.formatPreviewRule = formatPreviewRule;