"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsLandingPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _dashboards_table = require("../../../common/components/dashboards/dashboards_table");
var _landing_links_images = require("../../../landing_pages/components/landing_links_images");
var _constants = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _nav_links = require("../../../common/components/navigation/nav_links");
var _use_create_security_dashboard_link = require("../../../common/containers/dashboards/use_create_security_dashboard_link");
var _title = require("../../../common/components/header_page/title");
var _helpers = require("../../../common/components/links/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _telemetry = require("../../../common/lib/telemetry");
var _translations2 = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = ({
  canCreateDashboard
}) => {
  const {
    isLoading,
    url
  } = (0, _use_create_security_dashboard_link.useCreateSecurityDashboardLink)();
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: _translations2.DASHBOARDS_PAGE_TITLE
  })), canCreateDashboard && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_helpers.LinkButton, {
    isDisabled: isLoading,
    color: "primary",
    fill: true,
    iconType: "plusInCircle",
    href: url,
    onClick: ev => {
      ev.preventDefault();
      (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.CREATE_DASHBOARD}`);
      navigateTo({
        url
      });
    },
    "data-test-subj": "createDashboardButton"
  }, i18n.DASHBOARDS_PAGE_CREATE_BUTTON)));
};
const DashboardsLandingPage = () => {
  var _useAppRootNavLink$li, _useAppRootNavLink;
  const dashboardLinks = (_useAppRootNavLink$li = (_useAppRootNavLink = (0, _nav_links.useAppRootNavLink)(_constants.SecurityPageName.dashboards)) === null || _useAppRootNavLink === void 0 ? void 0 : _useAppRootNavLink.links) !== null && _useAppRootNavLink$li !== void 0 ? _useAppRootNavLink$li : [];
  const {
    show: canReadDashboard,
    createNew: canCreateDashboard
  } = (0, _kibana.useCapabilities)(_public.LEGACY_DASHBOARD_APP_ID);
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(Header, {
    canCreateDashboard: canCreateDashboard
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.DASHBOARDS_PAGE_SECTION_DEFAULT)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_landing_links_images.LandingImageCards, {
    items: dashboardLinks
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), canReadDashboard && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.DASHBOARDS_PAGE_SECTION_CUSTOM)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_dashboards_table.DashboardsTable, null)), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.dashboards
  }));
};
exports.DashboardsLandingPage = DashboardsLandingPage;