"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _kibana = require("../../../common/lib/kibana");
var _use_dashboard_view_prompt_state = require("../../hooks/use_dashboard_view_prompt_state");
var _dashboard_renderer = require("../../../common/components/dashboards/dashboard_renderer");
var _status_prompt = require("../../components/status_prompt");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _filters_global = require("../../../common/components/filters_global");
var _constants2 = require("../../../common/store/inputs/constants");
var _sourcerer = require("../../../common/containers/sourcerer");
var _header_page = require("../../../common/components/header_page");
var _translations = require("./translations");
var _store = require("../../../common/store");
var _use_selector = require("../../../common/hooks/use_selector");
var _edit_dashboard_button = require("../../components/edit_dashboard_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardViewFlexGroupStyle = {
  minHeight: `calc(100vh - 140px)`
};
const DashboardViewComponent = () => {
  var _dashboardDetails$tit;
  const {
    fromStr,
    toStr,
    from,
    to
  } = (0, _use_selector.useDeepEqualSelector)(state => (0, _fp.pick)(['fromStr', 'toStr', 'from', 'to'], _store.inputsSelectors.globalTimeRangeSelector(state)));
  const timeRange = (0, _react.useMemo)(() => ({
    from,
    to,
    fromStr,
    toStr
  }), [from, fromStr, to, toStr]);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    indexPattern,
    indicesExist
  } = (0, _sourcerer.useSourcererDataView)();
  const {
    show: canReadDashboard,
    showWriteControls
  } = (0, _kibana.useCapabilities)(_public.LEGACY_DASHBOARD_APP_ID);
  const errorState = (0, _react.useMemo)(() => canReadDashboard ? null : _use_dashboard_view_prompt_state.DashboardViewPromptState.NoReadPermission, [canReadDashboard]);
  const [dashboardDetails, setDashboardDetails] = (0, _react.useState)();
  const onDashboardContainerLoaded = (0, _react.useCallback)(dashboard => {
    if (dashboard) {
      const title = dashboard.getTitle().trim();
      if (title) {
        setDashboardDetails({
          title
        });
      } else {
        setDashboardDetails({
          title: _translations.DASHBOARD_NOT_FOUND_TITLE
        });
      }
    }
  }, []);
  const dashboardExists = (0, _react.useMemo)(() => dashboardDetails != null, [dashboardDetails]);
  const {
    detailName: savedObjectId
  } = (0, _reactRouterDom.useParams)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist && /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants2.InputsModelId.global,
    indexPattern: indexPattern
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: dashboardViewFlexGroupStyle,
    gutterSize: "none",
    "data-test-subj": "dashboard-view-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    title: (_dashboardDetails$tit = dashboardDetails === null || dashboardDetails === void 0 ? void 0 : dashboardDetails.title) !== null && _dashboardDetails$tit !== void 0 ? _dashboardDetails$tit : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })
  }, showWriteControls && dashboardExists && /*#__PURE__*/_react.default.createElement(_edit_dashboard_button.EditDashboardButton, {
    filters: filters,
    query: query,
    savedObjectId: savedObjectId,
    timeRange: timeRange
  }))), !errorState && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_dashboard_renderer.DashboardRenderer, {
    query: query,
    filters: filters,
    canReadDashboard: canReadDashboard,
    id: `dashboard-view-${savedObjectId}`,
    onDashboardContainerLoaded: onDashboardContainerLoaded,
    savedObjectId: savedObjectId,
    timeRange: timeRange
  })), errorState && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "dashboard-view-error-prompt-wrapper",
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_prompt.StatusPrompt, {
    currentState: errorState
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.dashboards,
    state: {
      dashboardName: dashboardDetails === null || dashboardDetails === void 0 ? void 0 : dashboardDetails.title
    }
  }))));
};
DashboardViewComponent.displayName = 'DashboardViewComponent';
const DashboardView = /*#__PURE__*/_react.default.memo(DashboardViewComponent);
exports.DashboardView = DashboardView;