"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMountAppended = void 0;
var _enzyme = require("enzyme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

const useMountAppended = () => {
  let root;
  beforeEach(() => {
    root = document.createElement('div');
    root.id = 'root';
    document.body.appendChild(root);
  });
  afterEach(() => {
    document.body.removeChild(root);
  });
  const mountAppended = (node, options) => (0, _enzyme.mount)(node, {
    ...options,
    attachTo: root
  });
  return mountAppended;
};
exports.useMountAppended = useMountAppended;