"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineClick = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _actions = require("../../../timelines/store/timeline/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineClick = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleTimelineClick = (0, _react.useCallback)((timelineId, onError, graphEventId) => {
    (0, _helpers.queryTimelineById)({
      graphEventId,
      timelineId,
      onError,
      updateIsLoading: ({
        id: currentTimelineId,
        isLoading
      }) => dispatch((0, _actions.updateIsLoading)({
        id: currentTimelineId,
        isLoading
      })),
      updateTimeline: (0, _helpers.dispatchUpdateTimeline)(dispatch)
    });
  }, [dispatch]);
  return handleTimelineClick;
};
exports.useTimelineClick = useTimelineClick;