"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowTimelineForGivenPath = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _links = require("../../links");
var _helpers = require("../../components/navigation/helpers");
var _model = require("../../store/sourcerer/model");
var _sourcerer = require("../../containers/sourcerer");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEPRECATED_HIDDEN_TIMELINE_ROUTES = [`/cases/configure`, '/administration', '/rules/create', '/get_started', '/explore', '/dashboards', '/manage', '/cloud_security_posture*'];
const isTimelinePathVisible = (currentPath, isGroupedNavigationEnabled) => {
  const groupLinksWithHiddenTimelinePaths = (0, _links.getLinksWithHiddenTimeline)().map(l => l.path);
  const hiddenTimelineRoutes = isGroupedNavigationEnabled ? groupLinksWithHiddenTimelinePaths : DEPRECATED_HIDDEN_TIMELINE_ROUTES;
  return !hiddenTimelineRoutes.find(route => (0, _reactRouterDom.matchPath)(currentPath, route));
};
const useShowTimelineForGivenPath = () => {
  const isGroupedNavigationEnabled = (0, _helpers.useIsGroupedNavigationEnabled)();
  const {
    indicesExist,
    dataViewId
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const userHasSecuritySolutionVisible = (0, _kibana.useKibana)().services.application.capabilities.siem.show;
  const isTimelineAllowed = (0, _react.useMemo)(() => userHasSecuritySolutionVisible && (indicesExist || dataViewId === null), [indicesExist, dataViewId, userHasSecuritySolutionVisible]);
  const getIsTimelineVisible = (0, _react.useCallback)(pathname => {
    if (!isTimelineAllowed) {
      return false;
    }
    return isTimelinePathVisible(pathname, isGroupedNavigationEnabled);
  }, [isTimelineAllowed, isGroupedNavigationEnabled]);
  return getIsTimelineVisible;
};
exports.useShowTimelineForGivenPath = useShowTimelineForGivenPath;