"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shortenCountIntoString = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shortenCountIntoString = count => {
  var _abbreviations$find;
  if (count < 10000) {
    return count.toString();
  }
  const abbreviations = [{
    magnitude: 1e18,
    unit: 'E'
  }, {
    magnitude: 1e15,
    unit: 'P'
  }, {
    magnitude: 1e12,
    unit: 'T'
  }, {
    magnitude: 1e9,
    unit: 'B'
  }, {
    magnitude: 1e6,
    unit: 'M'
  }, {
    magnitude: 1e3,
    unit: 'K'
  }];
  const {
    magnitude,
    unit
  } = (_abbreviations$find = abbreviations.find(abbreviation => count >= abbreviation.magnitude)) !== null && _abbreviations$find !== void 0 ? _abbreviations$find : {
    magnitude: 1,
    unit: ''
  };
  return toFixedWithoutRounding(count / magnitude, 1).replace(/\.0+$|(\.[0-9]*[1-9])0+$/, '$1') + unit;
};
exports.shortenCountIntoString = shortenCountIntoString;
const toFixedWithoutRounding = (n, p) => {
  const result = n.toFixed(p);
  return +result <= n ? result : (+result - Math.pow(0.1, p)).toFixed(p);
};