"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_ENDPOINT_FOR_RESPONDER = exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = exports.UPDATE_ALERT_STATUS_FAILED = exports.UNSAVED_TIMELINE_SAVE_PROMPT_TITLE = exports.UNSAVED_TIMELINE_SAVE_PROMPT = exports.SOLUTION_NAME = exports.INSUFFICIENT_PRIVILEGES_FOR_COMMAND = exports.BETA = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolution.pages.common.solutionName', {
  defaultMessage: 'Security'
});
exports.SOLUTION_NAME = SOLUTION_NAME;
const BETA = _i18n.i18n.translate('xpack.securitySolution.pages.common.beta', {
  defaultMessage: 'Beta'
});
exports.BETA = BETA;
const UPDATE_ALERT_STATUS_FAILED = conflicts => _i18n.i18n.translate('xpack.securitySolution.pages.common.updateAlertStatusFailed', {
  values: {
    conflicts
  },
  defaultMessage: 'Failed to update { conflicts } {conflicts, plural, =1 {alert} other {alerts}}.'
});
exports.UPDATE_ALERT_STATUS_FAILED = UPDATE_ALERT_STATUS_FAILED;
const UPDATE_ALERT_STATUS_FAILED_DETAILED = (updated, conflicts) => _i18n.i18n.translate('xpack.securitySolution.pages.common.updateAlertStatusFailedDetailed', {
  values: {
    updated,
    conflicts
  },
  defaultMessage: `{ updated } {updated, plural, =1 {alert was} other {alerts were}} updated successfully, but { conflicts } failed to update
         because { conflicts, plural, =1 {it was} other {they were}} already being modified.`
});
exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = UPDATE_ALERT_STATUS_FAILED_DETAILED;
const UPGRADE_ENDPOINT_FOR_RESPONDER = _i18n.i18n.translate('xpack.securitySolution.endpoint.actions.disabledResponder.tooltip', {
  defaultMessage: 'The current version of the Agent does not support this feature. Upgrade your Agent through Fleet to use this feature and new response actions such as killing and suspending processes.'
});
exports.UPGRADE_ENDPOINT_FOR_RESPONDER = UPGRADE_ENDPOINT_FOR_RESPONDER;
const INSUFFICIENT_PRIVILEGES_FOR_COMMAND = _i18n.i18n.translate('xpack.securitySolution.endpoint.actions.insufficientPrivileges.error', {
  defaultMessage: 'You do not have sufficient privileges to use this command. Please contact your administrator for access.'
});
exports.INSUFFICIENT_PRIVILEGES_FOR_COMMAND = INSUFFICIENT_PRIVILEGES_FOR_COMMAND;
const UNSAVED_TIMELINE_SAVE_PROMPT = _i18n.i18n.translate('xpack.securitySolution.timeline.unsavedWorkMessage', {
  defaultMessage: 'Leave Timeline with unsaved work?'
});
exports.UNSAVED_TIMELINE_SAVE_PROMPT = UNSAVED_TIMELINE_SAVE_PROMPT;
const UNSAVED_TIMELINE_SAVE_PROMPT_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.unsavedWorkTitle', {
  defaultMessage: 'Unsaved changes'
});
exports.UNSAVED_TIMELINE_SAVE_PROMPT_TITLE = UNSAVED_TIMELINE_SAVE_PROMPT_TITLE;