"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSelectedPatterns = exports.getScopePatternListSelection = exports.checkIfIndicesExist = void 0;
var _lodash = require("lodash");
var _model = require("./model");
var _sourcerer = require("../../../../common/utils/sourcerer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScopePatternListSelection = (theDataView, sourcererScope, signalIndexName, isDefaultDataView) => {
  const patternList = theDataView != null && theDataView.id !== null ? theDataView.patternList : [];
  if (!isDefaultDataView) {
    return (0, _sourcerer.sortWithExcludesAtEnd)(patternList);
  }
  // when our SIEM data view is set, here are the defaults
  switch (sourcererScope) {
    case _model.SourcererScopeName.default:
      return (0, _sourcerer.sortWithExcludesAtEnd)(patternList.filter(index => index !== signalIndexName));
    case _model.SourcererScopeName.detections:
      // set to signalIndexName whether or not it exists yet in the patternList
      return signalIndexName != null ? [signalIndexName] : [];
    case _model.SourcererScopeName.timeline:
      return (0, _sourcerer.sortWithExcludesAtEnd)(patternList);
  }
};
exports.getScopePatternListSelection = getScopePatternListSelection;
const validateSelectedPatterns = (state, payload, shouldValidateSelectedPatterns) => {
  var _dataView$id;
  const {
    id,
    ...rest
  } = payload;
  const dataView = state.kibanaDataViews.find(p => p.id === rest.selectedDataViewId);
  // dedupe because these could come from a silly url or pre 8.0 timeline
  const dedupePatterns = (0, _sourcerer.ensurePatternFormat)(rest.selectedPatterns);
  let missingPatterns = [];
  // check for missing patterns against default data view only
  if (dataView == null || dataView.id === state.defaultDataView.id) {
    const dedupeAllDefaultPatterns = (0, _sourcerer.ensurePatternFormat)((dataView !== null && dataView !== void 0 ? dataView : state.defaultDataView).title.split(','));
    missingPatterns = dedupePatterns.filter(pattern => !dedupeAllDefaultPatterns.includes(pattern));
  }
  const selectedPatterns =
  // shouldValidateSelectedPatterns is false when upgrading from
  // legacy pre-8.0 timeline index patterns to data view.
  shouldValidateSelectedPatterns && dataView != null && missingPatterns.length === 0 &&
  // don't validate when the data view has not been initialized (default is initialized already always)
  dataView.id !== state.defaultDataView.id && dataView.patternList.length > 0 ? dedupePatterns.filter(pattern => dataView != null && dataView.patternList.includes(pattern) ||
  // this is a hack, but sometimes signal index is deleted and is getting regenerated. it gets set before it is put in the dataView
  state.signalIndexName == null || state.signalIndexName === pattern) :
  // don't remove non-existing patterns, they were saved in the first place in timeline
  // but removed from the security data view
  // or its a legacy pre-8.0 timeline
  dedupePatterns;
  return {
    [id]: {
      ...state.sourcererScopes[id],
      ...rest,
      selectedDataViewId: (_dataView$id = dataView === null || dataView === void 0 ? void 0 : dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : null,
      selectedPatterns,
      missingPatterns,
      // if in timeline, allow for empty in case pattern was deleted
      // need flow for this
      ...((0, _lodash.isEmpty)(selectedPatterns) && id !== _model.SourcererScopeName.timeline ? {
        selectedPatterns: getScopePatternListSelection(dataView !== null && dataView !== void 0 ? dataView : state.defaultDataView, id, state.signalIndexName, (dataView !== null && dataView !== void 0 ? dataView : state.defaultDataView).id === state.defaultDataView.id)
      } : {}),
      loading: false
    }
  };
};
exports.validateSelectedPatterns = validateSelectedPatterns;
const checkIfIndicesExist = ({
  patternList,
  scopeId,
  signalIndexName,
  isDefaultDataViewSelected
}) => scopeId === _model.SourcererScopeName.detections ? patternList.includes(`${signalIndexName}`) : scopeId === _model.SourcererScopeName.default ? isDefaultDataViewSelected ? patternList.filter(i => i !== signalIndexName).length > 0 : patternList.length > 0 : patternList.length > 0;
exports.checkIfIndicesExist = checkIfIndicesExist;