"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNotNull = exports.createDataTableLocalStorageEpic = void 0;
var _operators = require("rxjs/operators");
var _fp = require("lodash/fp");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _actions = require("../../../timelines/store/timeline/actions");
var _local_storage = require("../../../timelines/containers/local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  applyDeltaToColumnWidth,
  changeViewMode,
  removeColumn,
  toggleDetailPanel,
  updateColumnOrder,
  updateColumns,
  updateColumnWidth,
  updateIsLoading,
  updateItemsPerPage,
  updateShowBuildingBlockAlertsFilter,
  updateSort,
  upsertColumn
} = _securitysolutionDataTable.dataTableActions;
const isNotNull = value => value !== null;
exports.isNotNull = isNotNull;
const tableActionTypes = [removeColumn.type, upsertColumn.type, applyDeltaToColumnWidth.type, updateColumns.type, updateColumnOrder.type, updateColumnWidth.type, updateItemsPerPage.type, updateSort.type, changeViewMode.type, updateShowBuildingBlockAlertsFilter.type, _actions.updateTotalCount.type, updateIsLoading.type, toggleDetailPanel.type];
const createDataTableLocalStorageEpic = () => (action$, state$, {
  tableByIdSelector,
  storage
}) => {
  const table$ = state$.pipe((0, _operators.map)(tableByIdSelector), (0, _operators.filter)(isNotNull));
  return action$.pipe((0, _operators.delay)(500), (0, _operators.withLatestFrom)(table$), (0, _operators.tap)(([action, tableById]) => {
    if (tableActionTypes.includes(action.type)) {
      if (storage) {
        const tableId = (0, _fp.get)('payload.id', action);
        (0, _local_storage.addTableInStorage)(storage, tableId, tableById[tableId]);
      }
    }
  }), (0, _operators.ignoreElements)());
};
exports.createDataTableLocalStorageEpic = createDataTableLocalStorageEpic;