"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.telemetryEvents = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsGroupingToggledEvent = {
  eventType: _types.TelemetryEventTypes.AlertsGroupingToggled,
  schema: {
    isOpen: {
      type: 'boolean',
      _meta: {
        description: 'on or off',
        optional: false
      }
    },
    tableId: {
      type: 'text',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupNumber: {
      type: 'integer',
      _meta: {
        description: 'Group number',
        optional: false
      }
    },
    groupName: {
      type: 'keyword',
      _meta: {
        description: 'Group value',
        optional: true
      }
    }
  }
};
const alertsGroupingChangedEvent = {
  eventType: _types.TelemetryEventTypes.AlertsGroupingChanged,
  schema: {
    tableId: {
      type: 'keyword',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupByField: {
      type: 'keyword',
      _meta: {
        description: 'Selected field',
        optional: false
      }
    }
  }
};
const alertsGroupingTakeActionEvent = {
  eventType: _types.TelemetryEventTypes.AlertsGroupingTakeAction,
  schema: {
    tableId: {
      type: 'keyword',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupNumber: {
      type: 'integer',
      _meta: {
        description: 'Group number',
        optional: false
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'Alert status',
        optional: false
      }
    },
    groupByField: {
      type: 'keyword',
      _meta: {
        description: 'Selected field',
        optional: false
      }
    }
  }
};
const entityClickedEvent = {
  eventType: _types.TelemetryEventTypes.EntityDetailsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const entityAlertsClickedEvent = {
  eventType: _types.TelemetryEventTypes.EntityAlertsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const entityRiskFilteredEvent = {
  eventType: _types.TelemetryEventTypes.EntityRiskFiltered,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    },
    selectedSeverity: {
      type: 'keyword',
      _meta: {
        description: 'Selected severity (Unknown|Low|Moderate|High|Critical)',
        optional: false
      }
    }
  }
};
const mlJobUpdateEvent = {
  eventType: _types.TelemetryEventTypes.MLJobUpdate,
  schema: {
    jobId: {
      type: 'keyword',
      _meta: {
        description: 'Job id',
        optional: false
      }
    },
    isElasticJob: {
      type: 'boolean',
      _meta: {
        description: 'If true the job is one of the pre-configure security solution modules',
        optional: false
      }
    },
    moduleId: {
      type: 'keyword',
      _meta: {
        description: 'Module id',
        optional: true
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'It describes what has changed in the job.',
        optional: false
      }
    },
    errorMessage: {
      type: 'text',
      _meta: {
        description: 'Error message',
        optional: true
      }
    }
  }
};
const cellActionClickedEvent = {
  eventType: _types.TelemetryEventTypes.CellActionClicked,
  schema: {
    fieldName: {
      type: 'keyword',
      _meta: {
        description: 'Field Name',
        optional: false
      }
    },
    actionId: {
      type: 'keyword',
      _meta: {
        description: 'Action id',
        optional: false
      }
    },
    displayName: {
      type: 'keyword',
      _meta: {
        description: 'User friendly action name',
        optional: false
      }
    },
    metadata: {
      type: 'pass_through',
      _meta: {
        description: 'Action metadata',
        optional: true
      }
    }
  }
};
const anomaliesCountClickedEvent = {
  eventType: _types.TelemetryEventTypes.AnomaliesCountClicked,
  schema: {
    jobId: {
      type: 'keyword',
      _meta: {
        description: 'Job id',
        optional: false
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of anomalies',
        optional: false
      }
    }
  }
};
const telemetryEvents = [alertsGroupingToggledEvent, alertsGroupingChangedEvent, alertsGroupingTakeActionEvent, entityClickedEvent, entityAlertsClickedEvent, entityRiskFilteredEvent, mlJobUpdateEvent, cellActionClickedEvent, anomaliesCountClickedEvent];
exports.telemetryEvents = telemetryEvents;