"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  track: true,
  initTelemetry: true,
  TELEMETRY_EVENT: true,
  getTelemetryEvent: true,
  METRIC_TYPE: true,
  telemetryMiddleware: true
};
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.initTelemetry = exports.getTelemetryEvent = exports.TELEMETRY_EVENT = void 0;
Object.defineProperty(exports, "telemetryMiddleware", {
  enumerable: true,
  get: function () {
    return _middleware.telemetryMiddleware;
  }
});
exports.track = void 0;
var _analytics = require("@kbn/analytics");
var _middleware = require("./middleware");
var _telemetry_client = require("./telemetry_client");
Object.keys(_telemetry_client).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _telemetry_client[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _telemetry_client[key];
    }
  });
});
var _telemetry_service = require("./telemetry_service");
Object.keys(_telemetry_service).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _telemetry_service[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _telemetry_service[key];
    }
  });
});
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noop = () => {};
let _track;
const track = (type, event, count) => {
  try {
    _track(type, event, count);
  } catch (error) {
    // ignore failed tracking call
  }
};
exports.track = track;
const initTelemetry = ({
  usageCollection
}, appId) => {
  var _usageCollection$repo, _usageCollection$repo2;
  _track = (_usageCollection$repo = usageCollection === null || usageCollection === void 0 ? void 0 : (_usageCollection$repo2 = usageCollection.reportUiCounter) === null || _usageCollection$repo2 === void 0 ? void 0 : _usageCollection$repo2.bind(null, appId)) !== null && _usageCollection$repo !== void 0 ? _usageCollection$repo : noop;
};
exports.initTelemetry = initTelemetry;
let TELEMETRY_EVENT;
exports.TELEMETRY_EVENT = TELEMETRY_EVENT;
(function (TELEMETRY_EVENT) {
  TELEMETRY_EVENT["SIEM_RULE_ENABLED"] = "siem_rule_enabled";
  TELEMETRY_EVENT["SIEM_RULE_DISABLED"] = "siem_rule_disabled";
  TELEMETRY_EVENT["CUSTOM_RULE_ENABLED"] = "custom_rule_enabled";
  TELEMETRY_EVENT["CUSTOM_RULE_DISABLED"] = "custom_rule_disabled";
  TELEMETRY_EVENT["SIEM_JOB_ENABLED"] = "siem_job_enabled";
  TELEMETRY_EVENT["SIEM_JOB_DISABLED"] = "siem_job_disabled";
  TELEMETRY_EVENT["CUSTOM_JOB_ENABLED"] = "custom_job_enabled";
  TELEMETRY_EVENT["CUSTOM_JOB_DISABLED"] = "custom_job_disabled";
  TELEMETRY_EVENT["JOB_ENABLE_FAILURE"] = "job_enable_failure";
  TELEMETRY_EVENT["JOB_DISABLE_FAILURE"] = "job_disable_failure";
  TELEMETRY_EVENT["TIMELINE_OPENED"] = "open_timeline";
  TELEMETRY_EVENT["TIMELINE_SAVED"] = "timeline_saved";
  TELEMETRY_EVENT["TIMELINE_NAMED"] = "timeline_named";
  TELEMETRY_EVENT["TAB_CLICKED"] = "tab_";
  TELEMETRY_EVENT["LANDING_CARD"] = "landing_card_";
  TELEMETRY_EVENT["DASHBOARD"] = "navigate_to_dashboard";
  TELEMETRY_EVENT["CREATE_DASHBOARD"] = "create_dashboard";
  TELEMETRY_EVENT["BREADCRUMB"] = "breadcrumb_";
  TELEMETRY_EVENT["LEGACY_NAVIGATION"] = "legacy_navigation_";
})(TELEMETRY_EVENT || (exports.TELEMETRY_EVENT = TELEMETRY_EVENT = {}));
const getTelemetryEvent = {
  groupedAlertsTakeAction: ({
    tableId,
    groupNumber,
    status
  }) => `alerts_table_${tableId}_group-${groupNumber}_mark-${status}`
};
exports.getTelemetryEvent = getTelemetryEvent;