"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToasts = exports.useTimeZone = exports.useNavigation = exports.useNavigateTo = exports.useHttp = exports.useGetUserCasesPermissions = exports.useDateFormat = exports.useCurrentUser = exports.useCapabilities = exports.useBasePath = exports.useAppUrl = exports.convertToCamelCase = exports.convertArrayToCamelCase = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _constants = require("../../../../common/constants");
var _toasters = require("../../components/toasters");
var _kibana_react = require("./kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDateFormat = () => (0, _kibana_react.useUiSetting)(_constants.DEFAULT_DATE_FORMAT);
exports.useDateFormat = useDateFormat;
const useTimeZone = () => {
  const timeZone = (0, _kibana_react.useUiSetting)(_constants.DEFAULT_DATE_FORMAT_TZ);
  return timeZone === 'Browser' ? _momentTimezone.default.tz.guess() : timeZone;
};
exports.useTimeZone = useTimeZone;
const useBasePath = () => (0, _kibana_react.useKibana)().services.http.basePath.get();
exports.useBasePath = useBasePath;
const useToasts = () => (0, _kibana_react.useKibana)().services.notifications.toasts;
exports.useToasts = useToasts;
const useHttp = () => (0, _kibana_react.useKibana)().services.http;
exports.useHttp = useHttp;
const convertArrayToCamelCase = arrayOfSnakes => arrayOfSnakes.reduce((acc, value) => {
  if ((0, _lodash.isArray)(value)) {
    return [...acc, convertArrayToCamelCase(value)];
  } else if ((0, _lodash.isObject)(value)) {
    return [...acc, convertToCamelCase(value)];
  } else {
    return [...acc, value];
  }
}, []);
exports.convertArrayToCamelCase = convertArrayToCamelCase;
const convertToCamelCase = snakeCase => Object.entries(snakeCase).reduce((acc, [key, value]) => {
  if ((0, _lodash.isArray)(value)) {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), convertArrayToCamelCase(value));
  } else if ((0, _lodash.isObject)(value)) {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), convertToCamelCase(value));
  } else {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), value);
  }
  return acc;
}, {});
exports.convertToCamelCase = convertToCamelCase;
const useCurrentUser = () => {
  const isMounted = (0, _react.useRef)(false);
  const [user, setUser] = (0, _react.useState)(null);
  const [, dispatchToaster] = (0, _toasters.useStateToaster)();
  const {
    security
  } = (0, _kibana_react.useKibana)().services;
  const fetchUser = (0, _react.useCallback)(() => {
    let didCancel = false;
    const fetchData = async () => {
      try {
        if (security != null) {
          const response = await security.authc.getCurrentUser();
          if (!isMounted.current) return;
          if (!didCancel) {
            setUser(convertToCamelCase(response));
          }
        } else {
          setUser({
            username: _i18n.i18n.translate('xpack.securitySolution.getCurrentUser.unknownUser', {
              defaultMessage: 'Unknown'
            }),
            email: '',
            fullName: '',
            roles: [],
            enabled: false,
            authenticationRealm: {
              name: '',
              type: ''
            },
            lookupRealm: {
              name: '',
              type: ''
            },
            authenticationProvider: ''
          });
        }
      } catch (error) {
        if (!didCancel) {
          (0, _toasters.errorToToaster)({
            title: _i18n.i18n.translate('xpack.securitySolution.getCurrentUser.Error', {
              defaultMessage: 'Error getting user'
            }),
            error: error.body && error.body.message ? new Error(error.body.message) : error,
            dispatchToaster
          });
          setUser(null);
        }
      }
    };
    fetchData();
    return () => {
      didCancel = true;
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [security]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    fetchUser();
    return () => {
      isMounted.current = false;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return user;
};
exports.useCurrentUser = useCurrentUser;
const useGetUserCasesPermissions = () => {
  const [casesPermissions, setCasesPermissions] = (0, _react.useState)({
    all: false,
    create: false,
    read: false,
    update: false,
    delete: false,
    push: false
  });
  const uiCapabilities = (0, _kibana_react.useKibana)().services.application.capabilities;
  const casesCapabilities = (0, _kibana_react.useKibana)().services.cases.helpers.getUICapabilities(uiCapabilities[_constants.CASES_FEATURE_ID]);
  (0, _react.useEffect)(() => {
    setCasesPermissions({
      all: casesCapabilities.all,
      create: casesCapabilities.create,
      read: casesCapabilities.read,
      update: casesCapabilities.update,
      delete: casesCapabilities.delete,
      push: casesCapabilities.push
    });
  }, [casesCapabilities.all, casesCapabilities.create, casesCapabilities.read, casesCapabilities.update, casesCapabilities.delete, casesCapabilities.push]);
  return casesPermissions;
};
exports.useGetUserCasesPermissions = useGetUserCasesPermissions;
/**
 * The `getAppUrl` function returns a full URL to the provided page path by using
 * kibana's `getUrlForApp()`
 */
const useAppUrl = () => {
  const {
    getUrlForApp
  } = (0, _kibana_react.useKibana)().services.application;
  const getAppUrl = (0, _react.useCallback)(({
    appId = _constants.APP_UI_ID,
    ...options
  }) => getUrlForApp(appId, options), [getUrlForApp]);
  return {
    getAppUrl
  };
};
exports.useAppUrl = useAppUrl;
/**
 * The `navigateTo` function navigates to any app using kibana's `navigateToApp()`.
 * When the `{ url: string }` parameter is passed it will navigate using `navigateToUrl()`.
 */
const useNavigateTo = () => {
  const {
    navigateToApp,
    navigateToUrl
  } = (0, _kibana_react.useKibana)().services.application;
  const navigateTo = (0, _react.useCallback)(({
    url,
    appId = _constants.APP_UI_ID,
    ...options
  }) => {
    if (url) {
      navigateToUrl(url);
    } else {
      navigateToApp(appId, options);
    }
  }, [navigateToApp, navigateToUrl]);
  return {
    navigateTo
  };
};

/**
 * Returns `navigateTo` and `getAppUrl` navigation hooks
 */
exports.useNavigateTo = useNavigateTo;
const useNavigation = () => {
  const {
    navigateTo
  } = useNavigateTo();
  const {
    getAppUrl
  } = useAppUrl();
  return {
    navigateTo,
    getAppUrl
  };
};

// Get the type for any feature capability
exports.useNavigation = useNavigation;
/**
 * Returns the feature capability when the `featureId` parameter is defined,
 * or the entire kibana `Capabilities` object when the parameter is omitted.
 */
const useCapabilities = featureId => {
  const {
    capabilities
  } = (0, _kibana_react.useKibana)().services.application;
  return featureId ? capabilities[featureId] : capabilities;
};
exports.useCapabilities = useCapabilities;