"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithCopyToClipboard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _accessibility = require("../../components/accessibility");
var i18n = _interopRequireWildcard(require("../../components/drag_and_drop/translations"));
var _clipboard = require("./clipboard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders `children` with an adjacent icon that when clicked, copies `text` to
 * the clipboard and displays a confirmation toast
 */
const WithCopyToClipboard = /*#__PURE__*/_react.default.memo(({
  isHoverAction,
  keyboardShortcut = '',
  text,
  titleSummary
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: /*#__PURE__*/_react.default.createElement(_accessibility.TooltipWithKeyboardShortcut, {
    additionalScreenReaderOnlyContext: text,
    content: i18n.COPY_TO_CLIPBOARD,
    shortcut: keyboardShortcut,
    showShortcut: keyboardShortcut !== ''
  })
}, /*#__PURE__*/_react.default.createElement(_clipboard.Clipboard, {
  content: text,
  isHoverAction: isHoverAction,
  titleSummary: titleSummary,
  toastLifeTimeMs: 800
})));
exports.WithCopyToClipboard = WithCopyToClipboard;
WithCopyToClipboard.displayName = 'WithCopyToClipboard';