"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddToTimelineCellAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _types = require("../../../../common/types");
var _data_driven_columns = require("../../../timelines/components/timeline/body/data_driven_columns");
var _data_provider = require("../../../timelines/components/timeline/data_providers/data_provider");
var _helpers = require("../../components/drag_and_drop/helpers");
var _helpers2 = require("./helpers");
var _actions = require("../../../timelines/store/timeline/actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAddToTimelineCellAction = ({
  data,
  pageSize,
  closeCellPopover
}) => data && data.length > 0 ? function AddToTimeline({
  rowIndex,
  columnId,
  Component
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timelines
  } = (0, _helpers2.useKibanaServices)();
  const pageRowIndex = (0, _securitysolutionDataTable.getPageRowIndex)(rowIndex, pageSize);
  const rowData = (0, _react.useMemo)(() => {
    return {
      data: data[pageRowIndex],
      fieldName: columnId
    };
  }, [pageRowIndex, columnId]);
  const value = (0, _data_driven_columns.useGetMappedNonEcsValue)(rowData);
  const addToTimelineButton = (0, _react.useMemo)(() => timelines.getHoverActions().getAddToTimelineButton, [timelines]);
  const dataProvider = (0, _react.useMemo)(() => {
    const queryIdPrefix = `${(0, _helpers.escapeDataProviderId)(columnId)}-row-${rowIndex}-col-${columnId}`;
    if (!value) {
      return [{
        and: [],
        enabled: true,
        kqlQuery: '',
        id: `${queryIdPrefix}`,
        name: '',
        excluded: true,
        queryMatch: {
          field: columnId,
          value: '',
          operator: _data_provider.EXISTS_OPERATOR
        }
      }];
    }
    return value.map(x => ({
      and: [],
      enabled: true,
      excluded: false,
      kqlQuery: '',
      id: `${queryIdPrefix}-val-${x}`,
      name: x,
      queryMatch: {
        field: columnId,
        value: x,
        operator: _data_provider.IS_OPERATOR
      }
    }));
  }, [columnId, rowIndex, value]);

  /*
   *   Add to Timeline button, adds data to dataprovider but does not persists the Timeline
   *   to the server because of following reasons.
   *
   *   1. Add to Timeline button performs actions in `timelines` plugin
   *   2. `timelines` plugin does not have information on how to create/update the timelines in the server
   *       as it is owned by Security Solution
   * */
  const handleAddToTimelineAction = (0, _react.useCallback)(() => {
    dispatch((0, _actions.addProvider)({
      id: _types.TimelineId.active,
      providers: dataProvider
    }));
    if (closeCellPopover) {
      closeCellPopover();
    }
  }, [dataProvider, dispatch]);
  const addToTimelineProps = (0, _react.useMemo)(() => {
    return {
      Component,
      dataProvider,
      field: columnId,
      ownFocus: false,
      showTooltip: false,
      onClick: handleAddToTimelineAction,
      timelineType: 'default'
    };
  }, [Component, columnId, dataProvider, handleAddToTimelineAction]);

  // data grid expects each cell action always return an element, it crashes if returns null
  return pageRowIndex >= data.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _helpers2.EmptyComponent) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, addToTimelineButton(addToTimelineProps));
} : _helpers2.EmptyComponent;
exports.getAddToTimelineCellAction = getAddToTimelineCellAction;