"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineEventsCountPortal = exports.useEqlEventsCountPortal = exports.TimelineEventsCountBadge = exports.EqlEventsCountBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A singleton portal for rendering content in the global header
 */
const timelineEventsCountPortalNodeSingleton = (0, _reactReversePortal.createHtmlPortalNode)();
const eqlEventsCountPortalNodeSingleton = (0, _reactReversePortal.createHtmlPortalNode)();
const useTimelineEventsCountPortal = () => {
  const [timelineEventsCountPortalNode] = (0, _react.useState)(timelineEventsCountPortalNodeSingleton);
  return {
    portalNode: timelineEventsCountPortalNode
  };
};
exports.useTimelineEventsCountPortal = useTimelineEventsCountPortal;
const TimelineEventsCountBadge = /*#__PURE__*/_react.default.memo(() => {
  const {
    portalNode
  } = useTimelineEventsCountPortal();
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: portalNode
  });
});
exports.TimelineEventsCountBadge = TimelineEventsCountBadge;
TimelineEventsCountBadge.displayName = 'TimelineEventsCountBadge';
const useEqlEventsCountPortal = () => {
  const [eqlEventsCountPortalNode] = (0, _react.useState)(eqlEventsCountPortalNodeSingleton);
  return {
    portalNode: eqlEventsCountPortalNode
  };
};
exports.useEqlEventsCountPortal = useEqlEventsCountPortal;
const EqlEventsCountBadge = /*#__PURE__*/_react.default.memo(() => {
  const {
    portalNode
  } = useEqlEventsCountPortal();
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: portalNode
  });
});
exports.EqlEventsCountBadge = EqlEventsCountBadge;
EqlEventsCountBadge.displayName = 'EqlEventsCountBadge';