"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardButtonHref = exports.dashboardRequestBody = void 0;
var _react = require("react");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardRequestBody = title => ({
  type: 'dashboard',
  search: `"${title}"`,
  fields: ['title']
});
exports.dashboardRequestBody = dashboardRequestBody;
const useDashboardButtonHref = ({
  to,
  from,
  title
}) => {
  const {
    dashboard,
    savedObjects: {
      client: savedObjectsClient
    }
  } = (0, _kibana.useKibana)().services;
  const [buttonHref, setButtonHref] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (dashboard !== null && dashboard !== void 0 && dashboard.locator && savedObjectsClient) {
      savedObjectsClient.find(dashboardRequestBody(title)).then(async DashboardsSO => {
        var _DashboardsSO$savedOb;
        if (DashboardsSO !== null && DashboardsSO !== void 0 && (_DashboardsSO$savedOb = DashboardsSO.savedObjects) !== null && _DashboardsSO$savedOb !== void 0 && _DashboardsSO$savedOb.length && to && from) {
          var _dashboard$locator;
          const dashboardUrl = await (dashboard === null || dashboard === void 0 ? void 0 : (_dashboard$locator = dashboard.locator) === null || _dashboard$locator === void 0 ? void 0 : _dashboard$locator.getUrl({
            dashboardId: DashboardsSO.savedObjects[0].id,
            timeRange: {
              to,
              from
            }
          }));
          setButtonHref(dashboardUrl);
        }
      });
    }
  }, [dashboard, from, savedObjectsClient, to, title]);
  return {
    buttonHref
  };
};
exports.useDashboardButtonHref = useDashboardButtonHref;