"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitTimelineFromUrlParam = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _global_query_string = require("../../utils/global_query_string");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _timeline = require("../../../timelines/store/timeline");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInitTimelineFromUrlParam = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const onInitialize = (0, _react.useCallback)(initialState => {
    if (initialState != null && initialState.id !== '') {
      (0, _helpers.queryTimelineById)({
        activeTimelineTab: initialState.activeTab,
        duplicate: false,
        graphEventId: initialState.graphEventId,
        timelineId: initialState.id,
        openTimeline: initialState.isOpen,
        updateIsLoading: status => dispatch(_timeline.timelineActions.updateIsLoading(status)),
        updateTimeline: (0, _helpers.dispatchUpdateTimeline)(dispatch)
      });
    }
  }, [dispatch]);
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.timeline, onInitialize);
};
exports.useInitTimelineFromUrlParam = useInitTimelineFromUrlParam;