"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncFlyoutUrlParam = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../../common/constants");
var _global_query_string = require("../../utils/global_query_string");
var _use_selector = require("../use_selector");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyncFlyoutUrlParam = () => {
  const updateUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.eventFlyout);
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const getDataTable = _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();

  // Only allow the alerts page for now to be saved in the url state
  const {
    expandedDetail
  } = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getDataTable;
    return (_getDataTable = getDataTable(state, _securitysolutionDataTable.TableId.alertsOnAlertsPage)) !== null && _getDataTable !== void 0 ? _getDataTable : _securitysolutionDataTable.tableDefaults;
  });
  (0, _react.useEffect)(() => {
    var _expandedDetail$query;
    const isOnAlertsPage = pathname === _constants.ALERTS_PATH;
    if (isOnAlertsPage && expandedDetail != null && expandedDetail !== null && expandedDetail !== void 0 && expandedDetail.query) {
      updateUrlParam(expandedDetail.query.panelView ? expandedDetail.query : null);
    } else if (!isOnAlertsPage && expandedDetail !== null && expandedDetail !== void 0 && (_expandedDetail$query = expandedDetail.query) !== null && _expandedDetail$query !== void 0 && _expandedDetail$query.panelView) {
      // Close the detail panel as it's stored in a top level redux store maintained across views
      dispatch(_securitysolutionDataTable.dataTableActions.toggleDetailPanel({
        id: _securitysolutionDataTable.TableId.alertsOnAlertsPage
      }));
      // Clear the reference from the url
      updateUrlParam(null);
    }
  }, [dispatch, expandedDetail, pathname, updateUrlParam]);
};
exports.useSyncFlyoutUrlParam = useSyncFlyoutUrlParam;