"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFirstLastSeen = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../use_search_strategy");
var _search_strategy = require("../../../../common/search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFirstLastSeen = ({
  field,
  value,
  order,
  defaultIndex,
  filterQuery
}) => {
  const {
    loading,
    result,
    search,
    error
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.FirstLastSeenQuery,
    initialResult: {
      firstSeen: null,
      lastSeen: null
    },
    errorMessage: i18n.FAIL_FIRST_LAST_SEEN_HOST
  });
  (0, _react.useEffect)(() => {
    search({
      defaultIndex,
      factoryQueryType: _search_strategy.FirstLastSeenQuery,
      field,
      value,
      order,
      filterQuery
    });
  }, [defaultIndex, field, value, order, search, filterQuery]);
  const setFirstLastSeenResponse = (0, _react.useMemo)(() => ({
    firstSeen: result.firstSeen,
    lastSeen: result.lastSeen,
    errorMessage: error ? error.toString() : null
  }), [result, error]);
  return [loading, setFirstLastSeenResponse];
};
exports.useFirstLastSeen = useFirstLastSeen;