"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityTagIds = exports.getSecurityDashboards = void 0;
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Request the security tag saved object and returns the id if exists.
 * It creates one if the tag doesn't exist.
 */
const getSecurityTagIds = async http => {
  const tagResponse = await (0, _api.getSecuritySolutionTags)({
    http
  });
  return tagResponse === null || tagResponse === void 0 ? void 0 : tagResponse.map(({
    id
  }) => id);
};

/**
 * Requests the saved objects of the security tagged dashboards
 */
exports.getSecurityTagIds = getSecurityTagIds;
const getSecurityDashboards = async http => {
  const dashboardsResponse = await (0, _api.getSecuritySolutionDashboards)({
    http
  });
  return dashboardsResponse;
};
exports.getSecurityDashboards = getSecurityDashboards;