"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateSecurityDashboardLink = void 0;
var _react = require("react");
var _kibana = require("../../lib/kibana");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateSecurityDashboardLink = () => {
  const {
    dashboard: {
      locator
    } = {},
    savedObjectsTagging,
    http
  } = (0, _kibana.useKibana)().services;
  const [securityTagId, setSecurityTagId] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    let ignore = false;
    const getOrCreateSecurityTag = async () => {
      if (http && savedObjectsTagging) {
        // getSecurityTagIds creates a tag if it coundn't find one
        const tagIds = await (0, _utils.getSecurityTagIds)(http);
        if (!ignore && tagIds) {
          setSecurityTagId(tagIds);
        }
      }
    };
    getOrCreateSecurityTag();
    return () => {
      ignore = true;
    };
  }, [http, savedObjectsTagging]);
  const result = (0, _react.useMemo)(() => {
    var _locator$getRedirectU;
    return {
      isLoading: securityTagId == null,
      url: securityTagId ? (_locator$getRedirectU = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
        tags: [securityTagId[0]]
      })) !== null && _locator$getRedirectU !== void 0 ? _locator$getRedirectU : '' : ''
    };
  }, [securityTagId, locator]);
  return result;
};
exports.useCreateSecurityDashboardLink = useCreateSecurityDashboardLink;