"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetRelatedCasesByEvent = void 0;
var _react = require("react");
var _kibana = require("../../lib/kibana");
var _translations = require("../../components/event_details/insights/translations");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetRelatedCasesByEvent = eventId => {
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const toasts = (0, _kibana.useToasts)();
  const [relatedCases, setRelatedCases] = (0, _react.useState)(undefined);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const getRelatedCases = (0, _react.useCallback)(async () => {
    setLoading(true);
    let relatedCasesResponse = [];
    try {
      if (eventId) {
        var _await$cases$api$getR;
        relatedCasesResponse = (_await$cases$api$getR = await cases.api.getRelatedCases(eventId, {
          owner: _constants.APP_ID
        })) !== null && _await$cases$api$getR !== void 0 ? _await$cases$api$getR : [];
      }
    } catch (err) {
      setError(err);
      toasts.addWarning((0, _translations.CASES_ERROR_TOAST)(err));
    } finally {
      setRelatedCases(relatedCasesResponse);
      setLoading(false);
    }
  }, [eventId, cases.api, toasts]);
  (0, _react.useEffect)(() => {
    getRelatedCases();
  }, [eventId, getRelatedCases]);
  return {
    loading,
    error,
    relatedCases,
    refetchRelatedCases: getRelatedCases
  };
};
exports.useGetRelatedCasesByEvent = useGetRelatedCasesByEvent;