"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.histogramConfigs = exports.anomaliesStackByOptions = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _matrix_histogram = require("../../../../../common/search_strategy/security_solution/matrix_histogram");
var _anomaliesStackByOpti;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const anomaliesStackByOptions = [{
  text: i18n.ANOMALIES_STACK_BY_JOB_ID,
  value: 'job_id'
}];
exports.anomaliesStackByOptions = anomaliesStackByOptions;
const DEFAULT_STACK_BY = i18n.ANOMALIES_STACK_BY_JOB_ID;
const histogramConfigs = {
  defaultStackByOption: (_anomaliesStackByOpti = anomaliesStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _anomaliesStackByOpti !== void 0 ? _anomaliesStackByOpti : anomaliesStackByOptions[0],
  errorMessage: i18n.ERROR_FETCHING_ANOMALIES_DATA,
  hideHistogramIfEmpty: true,
  histogramType: _matrix_histogram.MatrixHistogramType.anomalies,
  stackByOptions: anomaliesStackByOptions,
  subtitle: undefined,
  title: i18n.ANOMALIES_TITLE
};
exports.histogramConfigs = histogramConfigs;