"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithHoverActions = void 0;
var _eui = require("@elastic/eui");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * To avoid expensive changes to the DOM, delay showing the popover menu
 */
const HOVER_INTENT_DELAY = 100; // ms

// eslint-disable-next-line @typescript-eslint/no-explicit-any
const WithHoverActionsPopover = (0, _styledComponents.default)(_eui.EuiPopover)`
  .euiPopover__anchor {
    width: 100%;
  }
`;
/**
 * Decorates it's children with actions that are visible on hover.
 * This component does not enforce an opinion on the styling and
 * positioning of the hover content, but see the documentation for
 * the `hoverContent` for tips on (not) effecting layout on-hover.
 *
 * In addition to rendering the `hoverContent` prop on hover, this
 * component also passes `showHoverContent` as a render prop, which
 * provides a signal to the content that the user is in a hover state.
 *
 * IMPORTANT: This hover menu delegates focus management to the
 * `hoverContent` and does NOT own focus, because it should not
 * automatically "steal" focus. You must manage focus ownership,
 * otherwise it will be difficult for keyboard-only and screen
 * reader users to navigate to and from your popover.
 */
const WithHoverActions = /*#__PURE__*/_react.default.memo(({
  alwaysShow = false,
  closePopOverTrigger,
  hoverContent,
  onCloseRequested,
  render
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(hoverContent != null && alwaysShow);
  const [showHoverContent, setShowHoverContent] = (0, _react.useState)(false);
  const [, setHoverTimeout] = (0, _react.useState)(undefined);
  const popoverRef = (0, _react.useRef)(null);
  const tryClosePopover = (0, _react.useCallback)(() => {
    setHoverTimeout(prevHoverTimeout => {
      clearTimeout(prevHoverTimeout);
      return undefined;
    });
    setShowHoverContent(false);
    if (onCloseRequested != null) {
      onCloseRequested();
    }
  }, [onCloseRequested]);
  const onMouseEnter = (0, _react.useCallback)(() => {
    setHoverTimeout(Number(setTimeout(() => {
      // NOTE: the following read from the DOM is expensive, but not as
      // expensive as the default behavior, which adds a div to the body,
      // which-in turn performs a more expensive change to the layout
      if (!document.body.classList.contains(_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME)) {
        setShowHoverContent(true);
      }
    }, HOVER_INTENT_DELAY)));
  }, [setHoverTimeout, setShowHoverContent]);
  const onMouseLeave = (0, _react.useCallback)(() => {
    if (!alwaysShow) {
      tryClosePopover();
    }
  }, [alwaysShow, tryClosePopover]);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if (isOpen && keyboardEvent.key === 'Escape') {
      onMouseLeave();
    }
  }, [isOpen, onMouseLeave]);
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "withHoverActionsButton",
    onMouseEnter: onMouseEnter
  }, render(showHoverContent)), [onMouseEnter, render, showHoverContent]);
  (0, _react.useEffect)(() => {
    setIsOpen(hoverContent != null && (showHoverContent || alwaysShow));
  }, [hoverContent, showHoverContent, alwaysShow]);
  (0, _react.useEffect)(() => {
    setShowHoverContent(false);
  }, [closePopOverTrigger]); // NOTE: the `closePopOverTrigger` dependency here will close the hover menu whenever `closePopOverTrigger` changes

  (0, _react.useEffect)(() => {
    var _popoverRef$current;
    // in case of dynamic content i.e when the value of hoverContent changes,
    // we will try to reposition the popover so that the content does not collide with screen edge.
    if (isOpen) popoverRef === null || popoverRef === void 0 ? void 0 : (_popoverRef$current = popoverRef.current) === null || _popoverRef$current === void 0 ? void 0 : _popoverRef$current.positionPopoverFluid();
  }, [hoverContent, isOpen]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: alwaysShow ? _securitysolutionTGrid.HOVER_ACTIONS_ALWAYS_SHOW_CLASS_NAME : '',
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/_react.default.createElement(WithHoverActionsPopover, {
    ref: popoverRef,
    anchorPosition: 'downCenter',
    button: content,
    closePopover: tryClosePopover,
    hasArrow: false,
    isOpen: isOpen,
    ownFocus: false,
    panelPaddingSize: "none",
    panelClassName: "withHoverActions__popover",
    repositionOnScroll: true
  }, isOpen ? /*#__PURE__*/_react.default.createElement("div", {
    onKeyDown: onKeyDown
  }, hoverContent) : null));
});
exports.WithHoverActions = WithHoverActions;
WithHoverActions.displayName = 'WithHoverActions';