"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationEmbeddable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = require("styled-components");
var _chart_label = require("../../../overview/components/detection_response/alerts_by_status/chart_label");
var _use_selector = require("../../hooks/use_selector");
var _inputs = require("../../store/inputs");
var _donutchart = require("../charts/donutchart");
var _constants = require("../../store/inputs/constants");
var _use_refetch_by_session = require("../page/use_refetch_by_session");
var _lens_embeddable = require("./lens_embeddable");
var _sourcerer = require("../../containers/sourcerer");
var _use_visualization_response = require("./use_visualization_response");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VisualizationEmbeddableComponent = props => {
  var _visualizationData$, _visualizationData$$h;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    inputId = _constants.InputsModelId.global,
    id,
    isDonut,
    label,
    donutTextWrapperClassName,
    onLoad,
    ...lensProps
  } = props;
  const {
    session,
    refetchByRestartingSession,
    refetchByDeletingSession
  } = (0, _use_refetch_by_session.useRefetchByRestartingSession)({
    inputId,
    queryId: id
  });
  const {
    indicesExist
  } = (0, _sourcerer.useSourcererDataView)(lensProps.scopeId);
  const memorizedTimerange = (0, _react.useRef)(lensProps.timerange);
  const getGlobalQuery = _inputs.inputsSelectors.globalQueryByIdSelector();
  const {
    searchSessionId
  } = (0, _use_selector.useDeepEqualSelector)(state => getGlobalQuery(state, id));
  const visualizationData = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: id
  });
  const dataExists = visualizationData != null && ((_visualizationData$ = visualizationData[0]) === null || _visualizationData$ === void 0 ? void 0 : (_visualizationData$$h = _visualizationData$.hits) === null || _visualizationData$$h === void 0 ? void 0 : _visualizationData$$h.total) !== 0;
  const donutTextWrapperStyles = dataExists ? (0, _styledComponents.css)`
        top: 40%;
        right: 12%;
      ` : (0, _styledComponents.css)`
        top: 66%;
        right: 12%;
      `;
  const onEmbeddableLoad = (0, _react.useCallback)(({
    requests,
    responses,
    isLoading
  }) => {
    dispatch(_inputs.inputsActions.setQuery({
      inputId,
      id,
      searchSessionId: session.current.start(),
      refetch: refetchByRestartingSession,
      loading: isLoading,
      inspect: {
        dsl: requests,
        response: responses
      }
    }));
    if (typeof onLoad === 'function') {
      onLoad({
        requests,
        responses,
        isLoading
      });
    }
  }, [dispatch, inputId, id, session, refetchByRestartingSession, onLoad]);
  (0, _react.useEffect)(() => {
    var _memorizedTimerange$c, _memorizedTimerange$c2;
    // This handles timerange update when (alert) indices not found
    if (!indicesExist && ((_memorizedTimerange$c = memorizedTimerange.current) === null || _memorizedTimerange$c === void 0 ? void 0 : _memorizedTimerange$c.from) !== lensProps.timerange.from || ((_memorizedTimerange$c2 = memorizedTimerange.current) === null || _memorizedTimerange$c2 === void 0 ? void 0 : _memorizedTimerange$c2.to) !== lensProps.timerange.to) {
      memorizedTimerange.current = lensProps.timerange;
      dispatch(_inputs.inputsActions.deleteOneQuery({
        inputId,
        id
      }));
    }
  }, [dispatch, id, indicesExist, inputId, lensProps.timerange]);
  (0, _react.useEffect)(() => {
    // This handles initial mount and refetch when (alert) indices not found
    if (!searchSessionId) {
      setTimeout(() => {
        dispatch(_inputs.inputsActions.setQuery({
          inputId,
          id,
          searchSessionId: session.current.start(),
          refetch: dataExists ? refetchByRestartingSession : refetchByDeletingSession,
          loading: false,
          inspect: null
        }));
      }, 200);
    }
  }, [dispatch, inputId, id, session, dataExists, refetchByRestartingSession, searchSessionId, refetchByDeletingSession]);
  (0, _react.useEffect)(() => {
    return () => {
      dispatch(_inputs.inputsActions.deleteOneQuery({
        inputId,
        id
      }));
    };
  }, [dispatch, id, inputId]);
  if (!lensProps.getLensAttributes && !lensProps.lensAttributes || !lensProps.timerange) {
    return null;
  }
  if (isDonut) {
    var _visualizationData$2, _visualizationData$2$;
    return /*#__PURE__*/_react.default.createElement(_donutchart.DonutChartWrapper, {
      isChartEmbeddablesEnabled: true,
      dataExists: dataExists,
      label: label,
      title: dataExists ? /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
        count: (_visualizationData$2 = visualizationData[0]) === null || _visualizationData$2 === void 0 ? void 0 : (_visualizationData$2$ = _visualizationData$2.hits) === null || _visualizationData$2$ === void 0 ? void 0 : _visualizationData$2$.total
      }) : null,
      donutTextWrapperClassName: donutTextWrapperClassName,
      donutTextWrapperStyles: donutTextWrapperStyles
    }, /*#__PURE__*/_react.default.createElement(_lens_embeddable.LensEmbeddable, (0, _extends2.default)({}, lensProps, {
      id: id,
      onLoad: onEmbeddableLoad
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_lens_embeddable.LensEmbeddable, (0, _extends2.default)({}, lensProps, {
    id: id,
    onLoad: onEmbeddableLoad
  }));
};
const VisualizationEmbeddable = /*#__PURE__*/_react.default.memo(VisualizationEmbeddableComponent);
exports.VisualizationEmbeddable = VisualizationEmbeddable;