"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActions = void 0;
var _react = require("react");
var _kibana_react = require("../../lib/kibana/kibana_react");
var _use_add_to_existing_case = require("./use_add_to_existing_case");
var _use_add_to_new_case = require("./use_add_to_new_case");
var _translations = require("./translations");
var _translations2 = require("../inspect/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useActions = ({
  attributes,
  extraActions,
  inspectActionProps,
  timeRange,
  withActions
}) => {
  const {
    lens
  } = (0, _kibana_react.useKibana)().services;
  const {
    navigateToPrefilledEditor
  } = lens;
  const [defaultActions, setDefaultActions] = (0, _react.useState)(['inspect', 'addToNewCase', 'addToExistingCase', 'openInLens']);
  (0, _react.useEffect)(() => {
    if (withActions === false) {
      setDefaultActions([]);
    }
  }, [withActions]);
  const onOpenInLens = (0, _react.useCallback)(() => {
    if (!timeRange || !attributes) {
      return;
    }
    navigateToPrefilledEditor({
      id: '',
      timeRange,
      attributes
    }, {
      openInNewTab: true
    });
  }, [attributes, navigateToPrefilledEditor, timeRange]);
  const {
    disabled: isAddToExistingCaseDisabled,
    onAddToExistingCaseClicked
  } = (0, _use_add_to_existing_case.useAddToExistingCase)({
    lensAttributes: attributes,
    timeRange
  });
  const {
    onAddToNewCaseClicked,
    disabled: isAddToNewCaseDisabled
  } = (0, _use_add_to_new_case.useAddToNewCase)({
    timeRange,
    lensAttributes: attributes
  });
  const actions = (0, _react.useMemo)(() => defaultActions === null || defaultActions === void 0 ? void 0 : defaultActions.reduce((acc, action) => {
    if (action === 'inspect' && inspectActionProps != null) {
      return [...acc, getInspectAction({
        callback: inspectActionProps === null || inspectActionProps === void 0 ? void 0 : inspectActionProps.onInspectActionClicked,
        disabled: inspectActionProps === null || inspectActionProps === void 0 ? void 0 : inspectActionProps.isDisabled
      })];
    }
    if (action === 'addToExistingCase') {
      return [...acc, getAddToExistingCaseAction({
        callback: onAddToExistingCaseClicked,
        disabled: isAddToExistingCaseDisabled
      })];
    }
    if (action === 'addToNewCase') {
      return [...acc, getAddToNewCaseAction({
        callback: onAddToNewCaseClicked,
        disabled: isAddToNewCaseDisabled
      })];
    }
    if (action === 'openInLens') {
      return [...acc, getOpenInLensAction({
        callback: onOpenInLens
      })];
    }
    return acc;
  }, []), [defaultActions, inspectActionProps, onAddToExistingCaseClicked, isAddToExistingCaseDisabled, onAddToNewCaseClicked, isAddToNewCaseDisabled, onOpenInLens]);
  const withExtraActions = actions.concat(extraActions !== null && extraActions !== void 0 ? extraActions : []);
  return withExtraActions;
};
exports.useActions = useActions;
const getOpenInLensAction = ({
  callback
}) => {
  return {
    id: 'openInLens',
    getDisplayName(context) {
      return _translations.OPEN_IN_LENS;
    },
    getIconType(context) {
      return 'visArea';
    },
    type: 'actionButton',
    async isCompatible(context) {
      return true;
    },
    async execute(context) {
      callback();
    },
    order: 1
  };
};
const getAddToNewCaseAction = ({
  callback,
  disabled
}) => {
  return {
    id: 'addToNewCase',
    getDisplayName(context) {
      return _translations.ADD_TO_NEW_CASE;
    },
    getIconType(context) {
      return 'plusInCircle';
    },
    type: 'actionButton',
    async isCompatible(context) {
      return true;
    },
    async execute(context) {
      callback();
    },
    disabled,
    order: 3
  };
};
const getInspectAction = ({
  callback,
  disabled
}) => {
  return {
    id: 'inspect',
    getDisplayName(context) {
      return _translations2.INSPECT;
    },
    getIconType(context) {
      return 'inspect';
    },
    type: 'actionButton',
    async isCompatible(context) {
      return true;
    },
    async execute(context) {
      callback();
    },
    disabled,
    order: 4
  };
};
const getAddToExistingCaseAction = ({
  callback,
  disabled
}) => {
  return {
    id: 'addToExistingCase',
    getDisplayName(context) {
      return _translations.ADD_TO_EXISTING_CASE;
    },
    getIconType(context) {
      return 'plusInCircle';
    },
    type: 'actionButton',
    async isCompatible(context) {
      return true;
    },
    async execute(context) {
      callback();
    },
    disabled,
    order: 2
  };
};