"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialUserPrivilegesState = exports.UserPrivilegesProvider = exports.UserPrivilegesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _use_fetch_list_privileges = require("../../../detections/components/user_privileges/use_fetch_list_privileges");
var _use_fetch_detection_engine_privileges = require("../../../detections/components/user_privileges/use_fetch_detection_engine_privileges");
var _endpoint = require("./endpoint");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialUserPrivilegesState = () => ({
  listPrivileges: {
    loading: false,
    error: undefined,
    result: undefined
  },
  detectionEnginePrivileges: {
    loading: false,
    error: undefined,
    result: undefined
  },
  endpointPrivileges: (0, _endpoint.getEndpointPrivilegesInitialState)(),
  kibanaSecuritySolutionsPrivileges: {
    crud: false,
    read: false
  }
});
exports.initialUserPrivilegesState = initialUserPrivilegesState;
const UserPrivilegesContext = /*#__PURE__*/(0, _react.createContext)(initialUserPrivilegesState());
exports.UserPrivilegesContext = UserPrivilegesContext;
const UserPrivilegesProvider = ({
  kibanaCapabilities,
  children
}) => {
  const crud = kibanaCapabilities[_constants.SERVER_APP_ID].crud === true;
  const read = kibanaCapabilities[_constants.SERVER_APP_ID].show === true;
  const [kibanaSecuritySolutionsPrivileges, setKibanaSecuritySolutionsPrivileges] = (0, _react.useState)({
    crud,
    read
  });
  const listPrivileges = (0, _use_fetch_list_privileges.useFetchListPrivileges)(read);
  const detectionEnginePrivileges = (0, _use_fetch_detection_engine_privileges.useFetchDetectionEnginePrivileges)(read);
  const endpointPrivileges = (0, _endpoint.useEndpointPrivileges)();
  (0, _react.useEffect)(() => {
    setKibanaSecuritySolutionsPrivileges(currPrivileges => {
      if (currPrivileges.read !== read || currPrivileges.crud !== crud) {
        return {
          read,
          crud
        };
      }
      return currPrivileges;
    });
  }, [crud, read]);
  return /*#__PURE__*/_react.default.createElement(UserPrivilegesContext.Provider, {
    value: {
      listPrivileges,
      detectionEnginePrivileges,
      endpointPrivileges,
      kibanaSecuritySolutionsPrivileges
    }
  }, children);
};
exports.UserPrivilegesProvider = UserPrivilegesProvider;