"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopN = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _events_by_dataset = require("../../../overview/components/events_by_dataset");
var _signals_by_category = require("../../../overview/components/signals_by_category");
var _sourcerer = require("../../containers/sourcerer");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopNContainer = _styledComponents.default.div`
  min-width: 600px;
`;
const CloseButton = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  position: absolute;
  right: 4px;
  top: 4px;
`;
const ViewSelect = (0, _styledComponents.default)(_eui.EuiSuperSelect)`
  width: 170px;
`;
const TopNContent = _styledComponents.default.div`
  margin-top: 4px;
  margin-right: ${({
  theme
}) => theme.eui.euiSizeXS};

  .euiPanel {
    border: none;
  }
`;
const TopNComponent = ({
  combinedQueries,
  defaultView,
  deleteQuery,
  filters,
  field,
  from,
  indexPattern,
  options,
  paddingSize,
  query,
  showLegend,
  setAbsoluteRangeDatePickerTarget,
  setQuery,
  scopeId,
  to,
  toggleTopN
}) => {
  const [view, setView] = (0, _react.useState)(defaultView);
  const onViewSelected = (0, _react.useCallback)(value => setView(value), [setView]);
  const {
    selectedPatterns,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)((0, _helpers.getSourcererScopeName)({
    scopeId,
    view
  }));
  (0, _react.useEffect)(() => {
    setView(defaultView);
  }, [defaultView]);
  const headerChildren = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(ViewSelect, {
    "data-test-subj": "view-select",
    disabled: options.length === 1,
    onChange: onViewSelected,
    options: options,
    valueOfSelected: view
  }), [onViewSelected, options, view]);

  // alert workflow statuses (e.g. open | closed) and other alert-specific
  // filters must be ignored when viewing raw alerts
  const applicableFilters = (0, _react.useMemo)(() => (0, _helpers.removeIgnoredAlertFilters)({
    filters,
    tableId: scopeId,
    view
  }), [filters, scopeId, view]);
  return /*#__PURE__*/_react.default.createElement(TopNContainer, {
    "data-test-subj": "topN-container"
  }, /*#__PURE__*/_react.default.createElement(CloseButton, {
    "aria-label": i18n.CLOSE,
    "data-test-subj": "close",
    iconType: "cross",
    onClick: toggleTopN
  }), /*#__PURE__*/_react.default.createElement(TopNContent, null, view === 'raw' || view === 'all' ? /*#__PURE__*/_react.default.createElement(_events_by_dataset.EventsByDataset, {
    combinedQueries: combinedQueries,
    deleteQuery: deleteQuery,
    filters: applicableFilters,
    from: from,
    headerChildren: headerChildren,
    indexPattern: indexPattern,
    indexNames: selectedPatterns,
    runtimeMappings: runtimeMappings,
    onlyField: field,
    paddingSize: paddingSize,
    query: query,
    queryType: "topN",
    showLegend: showLegend,
    setAbsoluteRangeDatePickerTarget: setAbsoluteRangeDatePickerTarget,
    setQuery: setQuery,
    showSpacer: false,
    toggleTopN: toggleTopN,
    scopeId: scopeId,
    to: to,
    hideQueryToggle: true
  }) : /*#__PURE__*/_react.default.createElement(_signals_by_category.SignalsByCategory, {
    combinedQueries: combinedQueries,
    filters: applicableFilters,
    headerChildren: headerChildren,
    onlyField: field,
    paddingSize: paddingSize,
    query: query,
    showLegend: showLegend,
    setAbsoluteRangeDatePickerTarget: setAbsoluteRangeDatePickerTarget,
    runtimeMappings: runtimeMappings,
    hideQueryToggle: true
  })));
};
TopNComponent.displayName = 'TopNComponent';
const TopN = /*#__PURE__*/_react.default.memo(TopNComponent);
exports.TopN = TopN;