"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulTopN = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _helpers = require("../../../helpers");
var _constants = require("../../store/inputs/constants");
var _use_global_time = require("../../containers/use_global_time");
var _kibana = require("../../lib/kibana");
var _kuery = require("../../lib/kuery");
var _store = require("../../store");
var _defaults = require("../../../timelines/store/timeline/defaults");
var _timeline = require("../../../timelines/store/timeline");
var _helpers2 = require("./helpers");
var _top_n = require("./top_n");
var _timeline2 = require("../../../../common/types/timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_FILTERS = [];
const EMPTY_QUERY = {
  query: '',
  language: 'kuery'
};
const makeMapStateToProps = () => {
  const getGlobalQuerySelector = _store.inputsSelectors.globalQuerySelector();
  const getGlobalFiltersQuerySelector = _store.inputsSelectors.globalFiltersQuerySelector();
  const getTimeline = _timeline.timelineSelectors.getTimelineByIdSelector();
  const getInputsTimeline = _store.inputsSelectors.getTimelineSelector();
  const getKqlQueryTimeline = _timeline.timelineSelectors.getKqlFilterQuerySelector();

  // The mapped Redux state provided to this component includes the global
  // filters that appear at the top of most views in the app, and all the
  // filters in the active timeline:
  const mapStateToProps = (state, ownProps) => {
    var _getTimeline, _activeTimeline$filte;
    const activeTimeline = (_getTimeline = getTimeline(state, _timeline2.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const activeTimelineFilters = (_activeTimeline$filte = activeTimeline.filters) !== null && _activeTimeline$filte !== void 0 ? _activeTimeline$filte : EMPTY_FILTERS;
    const activeTimelineInput = getInputsTimeline(state);
    const {
      globalFilters
    } = ownProps;
    return {
      activeTimelineEventType: activeTimeline.eventType,
      activeTimelineFilters: activeTimeline.activeTab === _timeline2.TimelineTabs.query ? activeTimelineFilters : EMPTY_FILTERS,
      activeTimelineFrom: activeTimelineInput.timerange.from,
      activeTimelineKqlQueryExpression: activeTimeline.activeTab === _timeline2.TimelineTabs.query ? getKqlQueryTimeline(state, _timeline2.TimelineId.active) : null,
      activeTimelineTo: activeTimelineInput.timerange.to,
      dataProviders: activeTimeline.activeTab === _timeline2.TimelineTabs.query ? activeTimeline.dataProviders : [],
      globalQuery: getGlobalQuerySelector(state),
      globalFilters: globalFilters !== null && globalFilters !== void 0 ? globalFilters : getGlobalFiltersQuerySelector(state),
      kqlMode: activeTimeline.kqlMode
    };
  };
  return mapStateToProps;
};
const connector = (0, _reactRedux.connect)(makeMapStateToProps);

//  * `indexToAdd`, which enables the alerts index to be appended to
//    the `indexPattern` returned by `useWithSource`, may only be populated when
//    this component is rendered in the context of the active timeline. This
//    behavior enables the 'All events' view by appending the alerts index
//    to the index pattern.

const StatefulTopNComponent = ({
  activeTimelineEventType,
  activeTimelineFilters,
  activeTimelineFrom,
  activeTimelineKqlQueryExpression,
  activeTimelineTo,
  browserFields,
  dataProviders,
  field,
  indexPattern,
  globalFilters = EMPTY_FILTERS,
  globalQuery = EMPTY_QUERY,
  kqlMode,
  onFilterAdded,
  paddingSize,
  showLegend,
  scopeId,
  toggleTopN,
  value
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    from,
    deleteQuery,
    setQuery,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const options = (0, _helpers2.getOptions)((0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? activeTimelineEventType : undefined);
  const combinedQueries = (0, _react.useMemo)(() => {
    var _combineQueries;
    return (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? (_combineQueries = (0, _kuery.combineQueries)({
      browserFields,
      config: (0, _common.getEsQueryConfig)(uiSettings),
      dataProviders,
      filters: activeTimelineFilters,
      indexPattern,
      kqlMode,
      kqlQuery: {
        language: 'kuery',
        query: activeTimelineKqlQueryExpression !== null && activeTimelineKqlQueryExpression !== void 0 ? activeTimelineKqlQueryExpression : ''
      }
    })) === null || _combineQueries === void 0 ? void 0 : _combineQueries.filterQuery : undefined;
  }, [scopeId, browserFields, uiSettings, dataProviders, activeTimelineFilters, indexPattern, kqlMode, activeTimelineKqlQueryExpression]);
  const defaultView = (0, _react.useMemo)(() => (0, _helpers2.isDetectionsAlertsTable)(scopeId) ? 'alert' : options[0].value, [options, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_top_n.TopN, {
    combinedQueries: combinedQueries,
    "data-test-subj": "top-n",
    defaultView: defaultView,
    deleteQuery: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? undefined : deleteQuery,
    field: field,
    filters: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? EMPTY_FILTERS : globalFilters,
    from: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? activeTimelineFrom : from,
    indexPattern: indexPattern,
    options: options,
    paddingSize: paddingSize,
    query: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? EMPTY_QUERY : globalQuery,
    showLegend: showLegend,
    setAbsoluteRangeDatePickerTarget: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? _constants.InputsModelId.timeline : _constants.InputsModelId.global,
    setQuery: setQuery,
    scopeId: scopeId,
    to: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? activeTimelineTo : to,
    toggleTopN: toggleTopN,
    onFilterAdded: onFilterAdded,
    value: value
  });
};
StatefulTopNComponent.displayName = 'StatefulTopNComponent';
const StatefulTopN = connector( /*#__PURE__*/_react.default.memo(StatefulTopNComponent));
exports.StatefulTopN = StatefulTopN;