"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateAlertsStatus = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Update alert status by query
 *
 * @param useDetectionEngine logic flag for using the regular Detection Engine URL or the RAC URL
 *
 * @param status to update to('open' / 'closed' / 'acknowledged')
 * @param index index to be updated
 * @param query optional query object to update alerts by query.

 *
 * @throws An error if response is not OK
 */
const useUpdateAlertsStatus = () => {
  const {
    http
  } = (0, _public.useKibana)().services;
  return {
    updateAlertStatus: async ({
      status,
      index,
      query
    }) => {
      return http.fetch(_constants.DETECTION_ENGINE_SIGNALS_STATUS_URL, {
        method: 'POST',
        body: JSON.stringify({
          status,
          query
        })
      });
    }
  };
};
exports.useUpdateAlertsStatus = useUpdateAlertsStatus;