"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActionItems = exports.getUpdateAlertsQuery = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../../../common/types");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_update_alerts = require("./use_update_alerts");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _use_start_transaction = require("../../../lib/apm/use_start_transaction");
var _constants = require("../../../lib/apm/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUpdateAlertsQuery = eventIds => {
  return {
    bool: {
      filter: {
        terms: {
          _id: eventIds
        }
      }
    }
  };
};
exports.getUpdateAlertsQuery = getUpdateAlertsQuery;
const useBulkActionItems = ({
  eventIds,
  currentStatus,
  query,
  indexName,
  setEventsLoading,
  showAlertStatusActions = true,
  setEventsDeleted,
  onUpdateSuccess,
  onUpdateFailure,
  customBulkActions
}) => {
  const {
    updateAlertStatus
  } = (0, _use_update_alerts.useUpdateAlertsStatus)();
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const onAlertStatusUpdateSuccess = (0, _react.useCallback)((updated, conflicts, newStatus) => {
    if (conflicts > 0) {
      // Partial failure
      addWarning({
        title: i18n.UPDATE_ALERT_STATUS_FAILED(conflicts),
        text: i18n.UPDATE_ALERT_STATUS_FAILED_DETAILED(updated, conflicts)
      });
    } else {
      let title;
      switch (newStatus) {
        case 'closed':
          title = i18n.CLOSED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'open':
          title = i18n.OPENED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'acknowledged':
          title = i18n.ACKNOWLEDGED_ALERT_SUCCESS_TOAST(updated);
      }
      addSuccess({
        title
      });
    }
    if (onUpdateSuccess) {
      onUpdateSuccess(updated, conflicts, newStatus);
    }
  }, [addSuccess, addWarning, onUpdateSuccess]);
  const onAlertStatusUpdateFailure = (0, _react.useCallback)((newStatus, error) => {
    let title;
    switch (newStatus) {
      case 'closed':
        title = i18n.CLOSED_ALERT_FAILED_TOAST;
        break;
      case 'open':
        title = i18n.OPENED_ALERT_FAILED_TOAST;
        break;
      case 'acknowledged':
        title = i18n.ACKNOWLEDGED_ALERT_FAILED_TOAST;
    }
    addError(error.message, {
      title
    });
    if (onUpdateFailure) {
      onUpdateFailure(newStatus, error);
    }
  }, [addError, onUpdateFailure]);
  const onClickUpdate = (0, _react.useCallback)(async status => {
    if (query) {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.BULK_QUERY_STATUS_UPDATE
      });
    } else if (eventIds.length > 1) {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.BULK_STATUS_UPDATE
      });
    } else {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.STATUS_UPDATE
      });
    }
    try {
      var _response$updated, _response$version_con;
      setEventsLoading({
        eventIds,
        isLoading: true
      });
      const response = await updateAlertStatus({
        index: indexName,
        status,
        query: query ? JSON.parse(query) : getUpdateAlertsQuery(eventIds)
      });

      // TODO: Only delete those that were successfully updated from updatedRules
      setEventsDeleted({
        eventIds,
        isDeleted: true
      });
      if (response.version_conflicts && eventIds.length === 1) {
        throw new Error(i18n.BULK_ACTION_FAILED_SINGLE_ALERT);
      }
      onAlertStatusUpdateSuccess((_response$updated = response.updated) !== null && _response$updated !== void 0 ? _response$updated : 0, (_response$version_con = response.version_conflicts) !== null && _response$version_con !== void 0 ? _response$version_con : 0, status);
    } catch (error) {
      onAlertStatusUpdateFailure(status, error);
    } finally {
      setEventsLoading({
        eventIds,
        isLoading: false
      });
    }
  }, [setEventsLoading, eventIds, updateAlertStatus, indexName, query, setEventsDeleted, onAlertStatusUpdateSuccess, onAlertStatusUpdateFailure, startTransaction]);
  const items = (0, _react.useMemo)(() => {
    const actionItems = [];
    if (showAlertStatusActions) {
      if (currentStatus !== _types.FILTER_OPEN) {
        actionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "open",
          "data-test-subj": "open-alert-status",
          onClick: () => onClickUpdate(_types.FILTER_OPEN)
        }, i18n.BULK_ACTION_OPEN_SELECTED));
      }
      if (currentStatus !== _types.FILTER_ACKNOWLEDGED) {
        actionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "acknowledge",
          "data-test-subj": "acknowledged-alert-status",
          onClick: () => onClickUpdate(_types.FILTER_ACKNOWLEDGED)
        }, i18n.BULK_ACTION_ACKNOWLEDGED_SELECTED));
      }
      if (currentStatus !== _types.FILTER_CLOSED) {
        actionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "close",
          "data-test-subj": "close-alert-status",
          onClick: () => onClickUpdate(_types.FILTER_CLOSED)
        }, i18n.BULK_ACTION_CLOSE_SELECTED));
      }
    }
    const additionalItems = customBulkActions ? customBulkActions.reduce((acc, action) => {
      const isDisabled = !!(query && action.disableOnQuery);
      acc.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: action.key,
        disabled: isDisabled,
        "data-test-subj": action['data-test-subj'],
        toolTipContent: isDisabled ? action.disabledLabel : null,
        onClick: () => action.onClick(eventIds)
      }, action.label));
      return acc;
    }, []) : [];
    return [...actionItems, ...additionalItems];
  }, [currentStatus, customBulkActions, eventIds, onClickUpdate, query, showAlertStatusActions]);
  return items;
};
exports.useBulkActionItems = useBulkActionItems;