"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkActionsContainer = _styledComponents.default.div`
  display: inline-block;
  position: relative;
`;
BulkActionsContainer.displayName = 'BulkActionsContainer';

/**
 * Stateless component integrating the bulk actions menu and the select all button
 */
const BulkActionsComponent = ({
  selectText,
  selectClearAllText,
  showClearSelection,
  onSelectAll,
  onClearSelection,
  bulkActionItems
}) => {
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const toggleIsActionOpen = (0, _react.useCallback)(() => {
    setIsActionsPopoverOpen(currentIsOpen => !currentIsOpen);
  }, [setIsActionsPopoverOpen]);
  const closeActionPopover = (0, _react.useCallback)(() => {
    setIsActionsPopoverOpen(false);
  }, [setIsActionsPopoverOpen]);
  const closeIfPopoverIsOpen = (0, _react.useCallback)(() => {
    if (isActionsPopoverOpen) {
      setIsActionsPopoverOpen(false);
    }
  }, [isActionsPopoverOpen]);
  const toggleSelectAll = (0, _react.useCallback)(() => {
    if (!showClearSelection) {
      onSelectAll();
    } else {
      onClearSelection();
    }
  }, [onClearSelection, onSelectAll, showClearSelection]);
  return /*#__PURE__*/_react.default.createElement(BulkActionsContainer, {
    onClick: closeIfPopoverIsOpen,
    "data-test-subj": "bulk-actions-button-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isActionsPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": "selectedShowBulkActions",
      "data-test-subj": "selectedShowBulkActionsButton",
      size: "xs",
      iconType: "arrowDown",
      iconSide: "right",
      color: "primary",
      onClick: toggleIsActionOpen
    }, selectText),
    closePopover: closeActionPopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: bulkActionItems
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "aria-label": "selectAllAlerts",
    "data-test-subj": "selectAllAlertsButton",
    iconType: showClearSelection ? 'cross' : 'pagesSelect',
    onClick: toggleSelectAll
  }, selectClearAllText));
};
const BulkActions = /*#__PURE__*/_react.default.memo(BulkActionsComponent);
exports.BulkActions = BulkActions;